/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.net.URI;
import java.util.Objects;
import javax.net.ssl.SSLContext;

final class ConnectionKey {
    private final URI realUri;
    private final SSLContext sslContext;
    private final int hashCode;

    ConnectionKey(URI realUri, SSLContext sslContext) {
        this.realUri = realUri;
        this.sslContext = sslContext;
        this.hashCode = Objects.hash(realUri, sslContext);
    }

    URI getRealUri() {
        return this.realUri;
    }

    SSLContext getSslContext() {
        return this.sslContext;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConnectionKey && this.equals((ConnectionKey)obj);
    }

    boolean equals(ConnectionKey other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.realUri.equals(other.realUri) && Objects.equals(this.sslContext, other.sslContext);
    }

    public String toString() {
        return String.format("Connection key for uri=%s, ssl context=%s", this.realUri, this.sslContext);
    }
}

