/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineFormat;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestHeader;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;

public class OperationRequestCompleter
implements CommandLineCompleter {
    public static final OperationRequestCompleter INSTANCE = new OperationRequestCompleter();
    public static final CommandLineCompleter ARG_VALUE_COMPLETER = new CommandLineCompleter(){
        final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            try {
                this.parsedOp.parseOperation(ctx.getCurrentNodePath(), buffer);
            }
            catch (CommandFormatException e) {
                return -1;
            }
            return INSTANCE.complete(ctx, this.parsedOp, buffer, cursor, candidates);
        }
    };
    public static final EscapeSelector ESCAPE_SELECTOR = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == ':' || ch == '/' || ch == '=' || ch == ' ' || ch == '\"' || ch == '\\';
        }
    };

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, ctx.getParsedCommandLine(), buffer, cursor, candidates);
    }

    public int complete(CommandContext ctx, ParsedCommandLine parsedCmd, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, parsedCmd, ctx.getOperationCandidatesProvider(), buffer, cursor, candidates);
    }

    public int complete(CommandContext ctx, ParsedCommandLine parsedCmd, OperationCandidatesProvider candidatesProvider, String buffer, int cursor, List<String> candidates) {
        String chunk;
        if (parsedCmd.isRequestComplete()) {
            return -1;
        }
        if (parsedCmd.endsOnHeaderListStart() || parsedCmd.hasHeaders()) {
            Map<String, OperationRequestHeader> headers = candidatesProvider.getHeaders(ctx);
            if (headers.isEmpty()) {
                return -1;
            }
            int result = buffer.length();
            if (parsedCmd.getLastHeaderName() != null) {
                if (buffer.endsWith(parsedCmd.getLastHeaderName())) {
                    result = parsedCmd.getLastChunkIndex();
                    for (String name : headers.keySet()) {
                        if (parsedCmd.hasHeader(name) || !name.startsWith(parsedCmd.getLastHeaderName())) continue;
                        candidates.add(name);
                    }
                } else {
                    OperationRequestHeader header = headers.get(parsedCmd.getLastHeaderName());
                    if (header == null) {
                        return -1;
                    }
                    CommandLineCompleter headerCompleter = header.getCompleter();
                    if (headerCompleter == null) {
                        return -1;
                    }
                    int valueResult = headerCompleter.complete(ctx, buffer.substring(parsedCmd.getLastChunkIndex()), cursor, candidates);
                    if (valueResult < 0) {
                        return -1;
                    }
                    result = parsedCmd.getLastChunkIndex() + valueResult;
                }
            } else if (!parsedCmd.hasHeaders()) {
                candidates.addAll(headers.keySet());
            } else if (parsedCmd.endsOnHeaderSeparator()) {
                candidates.addAll(headers.keySet());
                for (ParsedOperationRequestHeader parsed : parsedCmd.getHeaders()) {
                    candidates.remove(parsed.getName());
                }
            } else {
                ParsedOperationRequestHeader lastParsedHeader = parsedCmd.getLastHeader();
                OperationRequestHeader lastHeader = headers.get(lastParsedHeader.getName());
                if (lastHeader == null) {
                    return -1;
                }
                CommandLineCompleter headerCompleter = lastHeader.getCompleter();
                if (headerCompleter == null) {
                    return -1;
                }
                result = headerCompleter.complete(ctx, buffer, cursor, candidates);
            }
            Collections.sort(candidates);
            return result;
        }
        if (parsedCmd.endsOnPropertyListEnd()) {
            return buffer.length();
        }
        if (parsedCmd.hasProperties() || parsedCmd.endsOnPropertyListStart()) {
            Collection<CommandArgument> allArgs = candidatesProvider.getProperties(ctx, parsedCmd.getOperationName(), parsedCmd.getAddress());
            if (allArgs.isEmpty()) {
                CommandLineFormat format = parsedCmd.getFormat();
                if (format != null && format.getPropertyListEnd() != null) {
                    candidates.add(format.getPropertyListEnd());
                }
                return buffer.length();
            }
            try {
                if (!parsedCmd.hasProperties()) {
                    for (CommandArgument arg : allArgs) {
                        if (!arg.canAppearNext(ctx)) continue;
                        if (arg.getIndex() >= 0) {
                            CommandLineCompleter valCompl = arg.getValueCompleter();
                            if (valCompl == null) continue;
                            valCompl.complete(ctx, "", 0, candidates);
                            continue;
                        }
                        String argName = arg.getFullName();
                        if (arg.isValueRequired()) {
                            argName = argName + '=';
                        }
                        candidates.add(argName);
                    }
                    Collections.sort(candidates);
                    return buffer.length();
                }
            }
            catch (CommandFormatException e) {
                return -1;
            }
            int result = buffer.length();
            String chunk2 = null;
            CommandLineCompleter valueCompleter = null;
            if (!parsedCmd.endsOnPropertySeparator()) {
                String argName = parsedCmd.getLastParsedPropertyName();
                String argValue = parsedCmd.getLastParsedPropertyValue();
                if (argValue != null || parsedCmd.endsOnPropertyValueSeparator()) {
                    result = parsedCmd.getLastChunkIndex();
                    if (parsedCmd.endsOnPropertyValueSeparator()) {
                        ++result;
                    }
                    chunk2 = argValue;
                    valueCompleter = argName != null ? this.getValueCompleter(ctx, allArgs, argName) : this.getValueCompleter(ctx, allArgs, parsedCmd.getOtherProperties().size() - 1);
                    if (valueCompleter == null) {
                        CommandLineFormat format;
                        if (parsedCmd.endsOnSeparator()) {
                            return -1;
                        }
                        for (CommandArgument arg : allArgs) {
                            try {
                                if (!arg.canAppearNext(ctx) || arg.getFullName().equals(argName)) continue;
                                return -1;
                            }
                            catch (CommandFormatException e) {
                                break;
                            }
                        }
                        if ((format = parsedCmd.getFormat()) != null && format.getPropertyListEnd() != null) {
                            candidates.add(format.getPropertyListEnd());
                        }
                        return buffer.length();
                    }
                } else {
                    chunk2 = argName;
                    result = parsedCmd.getLastChunkIndex();
                }
            } else {
                chunk2 = null;
            }
            if (valueCompleter != null) {
                int valueResult = valueCompleter.complete(ctx, chunk2 == null ? "" : chunk2, 0, candidates);
                if (valueResult < 0) {
                    return valueResult;
                }
                return result + valueResult;
            }
            for (CommandArgument arg : allArgs) {
                try {
                    if (!arg.canAppearNext(ctx)) continue;
                    if (arg.getIndex() >= 0) {
                        CommandLineCompleter valCompl = arg.getValueCompleter();
                        if (valCompl == null) continue;
                        String value = chunk2 == null ? "" : chunk2;
                        valCompl.complete(ctx, value, value.length(), candidates);
                        continue;
                    }
                    String argFullName = arg.getFullName();
                    if (chunk2 == null) {
                        if (arg.isValueRequired()) {
                            argFullName = argFullName + '=';
                        }
                        candidates.add(argFullName);
                        continue;
                    }
                    if (!argFullName.startsWith(chunk2)) continue;
                    if (arg.isValueRequired()) {
                        argFullName = argFullName + '=';
                    }
                    candidates.add(argFullName);
                }
                catch (CommandFormatException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            if (candidates.isEmpty()) {
                CommandLineFormat format;
                if (chunk2 == null && !parsedCmd.endsOnSeparator() && (format = parsedCmd.getFormat()) != null && format.getPropertyListEnd() != null) {
                    candidates.add(format.getPropertyListEnd());
                }
            } else {
                Collections.sort(candidates);
            }
            return result;
        }
        if (parsedCmd.hasOperationName() || parsedCmd.endsOnAddressOperationNameSeparator()) {
            if (parsedCmd.getAddress().endsOnType()) {
                return -1;
            }
            Collection<String> names = candidatesProvider.getOperationNames(ctx, parsedCmd.getAddress());
            if (names.isEmpty()) {
                return -1;
            }
            String chunk3 = parsedCmd.getOperationName();
            if (chunk3 == null) {
                candidates.addAll(names);
            } else {
                for (String name : names) {
                    if (!name.startsWith(chunk3)) continue;
                    candidates.add(name);
                }
            }
            Collections.sort(candidates);
            if (parsedCmd.endsOnSeparator()) {
                return buffer.length();
            }
            if (chunk3 != null && candidates.size() == 1 && chunk3.equals(candidates.get(0)) && parsedCmd.getFormat().getPropertyListStart().length() > 0) {
                candidates.set(0, chunk3 + parsedCmd.getFormat().getPropertyListStart());
            }
            return parsedCmd.getLastChunkIndex();
        }
        OperationRequestAddress address = parsedCmd.getAddress();
        if (buffer.endsWith("..")) {
            return -1;
        }
        if (address.isEmpty() || parsedCmd.endsOnNodeSeparator() || parsedCmd.endsOnNodeTypeNameSeparator() || address.equals(ctx.getCurrentNodePath())) {
            chunk = null;
        } else if (address.endsOnType()) {
            chunk = address.getNodeType();
            address.toParentNode();
        } else {
            chunk = address.toNodeType();
        }
        Collection<String> names = address.endsOnType() ? candidatesProvider.getNodeNames(ctx, address) : candidatesProvider.getNodeTypes(ctx, address);
        if (names.isEmpty()) {
            return -1;
        }
        if (chunk == null) {
            candidates.addAll(names);
        } else {
            for (String name : names) {
                if (!name.startsWith(chunk)) continue;
                candidates.add(name);
            }
        }
        if (candidates.size() == 1) {
            if (address.endsOnType()) {
                if (chunk != null && chunk.equals(candidates.get(0))) {
                    candidates.set(0, parsedCmd.getFormat().getAddressOperationSeparator());
                    candidates.add(parsedCmd.getFormat().getNodeSeparator());
                    return buffer.length();
                }
                candidates.set(0, Util.escapeString(candidates.get(0), ESCAPE_SELECTOR));
            } else {
                candidates.set(0, Util.escapeString(candidates.get(0), ESCAPE_SELECTOR) + '=');
            }
        } else {
            Util.sortAndEscape(candidates, ESCAPE_SELECTOR);
        }
        return parsedCmd.endsOnSeparator() ? parsedCmd.getLastSeparatorIndex() + 1 : parsedCmd.getLastChunkIndex();
    }

    protected CommandLineCompleter getValueCompleter(CommandContext ctx, Iterable<CommandArgument> allArgs, String argName) {
        CommandLineCompleter result = null;
        for (CommandArgument arg : allArgs) {
            if (arg.getFullName().equals(argName)) {
                return arg.getValueCompleter();
            }
            if (arg.getIndex() != Integer.MAX_VALUE) continue;
            result = arg.getValueCompleter();
        }
        return result;
    }

    protected CommandLineCompleter getValueCompleter(CommandContext ctx, Iterable<CommandArgument> allArgs, int index) {
        CommandLineCompleter maxIndex = null;
        for (CommandArgument arg : allArgs) {
            if (arg.getIndex() == index) {
                return arg.getValueCompleter();
            }
            if (arg.getIndex() != Integer.MAX_VALUE) continue;
            maxIndex = arg.getValueCompleter();
        }
        return maxIndex;
    }
}

