/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channeltools.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.io.PomIO;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.Stream;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channeltools.cli.ChannelInputArgGroup;
import org.wildfly.channeltools.cli.CliLogger;
import org.wildfly.channeltools.cli.ResolutionArgGroup;
import org.wildfly.channeltools.resolver.ChannelBuilder;
import org.wildfly.channeltools.resolver.DefaultMavenVersionsResolverFactory;
import org.wildfly.channeltools.util.PMEUtils;
import picocli.CommandLine;

@CommandLine.Command(description={"Generates a Maven BOM for given project POM file.", "If a channel is configured, it will be used to upgrade detected dependencies in the generated BOM."})
public class GenerateBomCommand
implements Runnable {
    private static final String VERSION_PREFIX = "version.";
    @CommandLine.Option(names={"-i", "--input-pom"}, required=true, description={"Source POM file"})
    File fromFile;
    @CommandLine.Option(names={"-o", "--output-pom"}, required=true, description={"Output BOM file"})
    File outputFile;
    @CommandLine.Option(names={"--gav"}, required=true, description={"GAV of the generated BOM file"})
    String gavString;
    @CommandLine.ArgGroup
    ChannelInputArgGroup channelInputGroup = new ChannelInputArgGroup();
    @CommandLine.ArgGroup
    ResolutionArgGroup resolutionArgGroup = new ResolutionArgGroup();

    @Override
    public void run() {
        Project project;
        DefaultMavenVersionsResolverFactory resolverFactory;
        ChannelSession channelSession = null;
        Channel channel = null;
        if (!this.channelInputGroup.isEmpty() && (channel = new ChannelBuilder(resolverFactory = new DefaultMavenVersionsResolverFactory(this.resolutionArgGroup.remoteRepositories, this.resolutionArgGroup.localRepository, this.resolutionArgGroup.disableTlsVerification)).setChannelGav(this.channelInputGroup.gav).setChannelFile(this.channelInputGroup.file).build()) != null) {
            channelSession = new ChannelSession(Collections.singletonList(channel), resolverFactory);
        }
        ManipulationSession manipulationSession = new ManipulationSession();
        PomIO pomIO = new PomIO(manipulationSession);
        try {
            project = PMEUtils.parseProject(pomIO, this.fromFile);
        }
        catch (ManipulationException e) {
            throw new RuntimeException("Couldn't parse input POM", e);
        }
        ProjectVersionRef gav = SimpleProjectVersionRef.parse(this.gavString);
        Model model = new Model();
        model.setGroupId(gav.getGroupId());
        model.setArtifactId(gav.getArtifactId());
        model.setVersion(gav.getVersionString());
        model.setDependencyManagement(new DependencyManagement());
        model.setProperties(new SortedProperties());
        HashSet<Map.Entry<ArtifactRef, Dependency>> projectDependencies = new HashSet<Map.Entry<ArtifactRef, Dependency>>();
        try {
            projectDependencies.addAll(project.getResolvedManagedDependencies(manipulationSession).entrySet());
            projectDependencies.addAll(project.getResolvedDependencies(manipulationSession).entrySet());
        }
        catch (ManipulationException e) {
            throw new RuntimeException("Couldn't resolve dependencies from input POM", e);
        }
        List sortedDependencies = projectDependencies.stream().sorted((e1, e2) -> ((ArtifactRef)e1.getKey()).compareTo((ProjectRef)e2.getKey())).collect(Collectors.toList());
        for (Map.Entry entry : sortedDependencies) {
            if ("test".equals(((Dependency)entry.getValue()).getScope())) continue;
            ArtifactRef artifact = (ArtifactRef)entry.getKey();
            Dependency dependency = (Dependency)entry.getValue();
            String newVersion = artifact.getVersionString();
            if (channelSession != null) {
                Optional<Stream> streamOptional = channel.findStreamFor(artifact.getGroupId(), artifact.getArtifactId());
                if (streamOptional.isPresent()) {
                    try {
                        MavenArtifact resolvedArtifact = channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
                        newVersion = resolvedArtifact.getVersion();
                    }
                    catch (UnresolvedMavenArtifactException e) {
                        CliLogger.LOGGER.errorf((Throwable)e, "Channel unable to resolve dependency %s", (Object)artifact);
                    }
                } else {
                    CliLogger.LOGGER.warnf("No stream found for %s", (Object)artifact);
                }
            }
            String propertyName = GenerateBomCommand.determinePropertyName(model.getProperties(), artifact, dependency, newVersion);
            model.getProperties().put(propertyName, newVersion);
            CliLogger.LOGGER.infof("Adding dependency %s:%s:%s", (Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), (Object)newVersion);
            model.getDependencyManagement().getDependencies().add(GenerateBomCommand.dependency(artifact, propertyName));
        }
        try {
            MavenXpp3Writer pomWriter = new MavenXpp3Writer();
            pomWriter.write(new FileOutputStream(this.outputFile), model);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write output POM", e);
        }
    }

    private static String determinePropertyName(Properties existingProperties, ArtifactRef artifact, Dependency dependency, String newVersion) {
        if (existingProperties.getProperty(VERSION_PREFIX + artifact.getGroupId()) == null || existingProperties.getProperty(VERSION_PREFIX + artifact.getGroupId()).equals(newVersion)) {
            return VERSION_PREFIX + artifact.getGroupId();
        }
        if (existingProperties.getProperty(VERSION_PREFIX + artifact.getGroupId() + "." + artifact.getArtifactId()) == null || existingProperties.getProperty(VERSION_PREFIX + artifact.getGroupId() + "." + artifact.getArtifactId()).equals(newVersion)) {
            return VERSION_PREFIX + artifact.getGroupId() + "." + artifact.getArtifactId();
        }
        throw new IllegalStateException(String.format("Detected multiple dependencies for %s:%s with different versions.", artifact.getGroupId(), artifact.getArtifactId()));
    }

    private static Dependency dependency(ArtifactRef ref, String versionPropertyName) {
        Dependency d = new Dependency();
        d.setGroupId(ref.getGroupId());
        d.setArtifactId(ref.getArtifactId());
        d.setVersion("${" + versionPropertyName + "}");
        d.setType(ref.getType());
        d.setClassifier(ref.getClassifier());
        return d;
    }

    static class SortedProperties
    extends Properties {
        SortedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            return Collections.unmodifiableSet(new TreeSet<Object>(super.keySet()));
        }
    }
}

