/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.reports.model.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.jboss.da.model.rest.NPMPackage;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class VersionsNPMRequest {
    private final VersionFilter versionFilter;
    @NotNull
    private final String mode;
    @NonNull
    private final List<NPMPackage> packages;
    private final boolean includeAll;

    VersionsNPMRequest(VersionFilter versionFilter, String mode, @NonNull List<NPMPackage> packages, boolean includeAll) {
        if (packages == null) {
            throw new NullPointerException("packages is marked non-null but is null");
        }
        this.versionFilter = versionFilter;
        this.mode = mode;
        this.packages = packages;
        this.includeAll = includeAll;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VersionFilter getVersionFilter() {
        return this.versionFilter;
    }

    public String getMode() {
        return this.mode;
    }

    @NonNull
    public List<NPMPackage> getPackages() {
        return this.packages;
    }

    public boolean isIncludeAll() {
        return this.includeAll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionsNPMRequest)) {
            return false;
        }
        VersionsNPMRequest other = (VersionsNPMRequest)o;
        if (this.isIncludeAll() != other.isIncludeAll()) {
            return false;
        }
        VersionFilter this$versionFilter = this.getVersionFilter();
        VersionFilter other$versionFilter = other.getVersionFilter();
        if (this$versionFilter == null ? other$versionFilter != null : !((Object)((Object)this$versionFilter)).equals((Object)other$versionFilter)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        List<NPMPackage> this$packages = this.getPackages();
        List<NPMPackage> other$packages = other.getPackages();
        return !(this$packages == null ? other$packages != null : !((Object)this$packages).equals(other$packages));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeAll() ? 79 : 97);
        VersionFilter $versionFilter = this.getVersionFilter();
        result = result * 59 + ($versionFilter == null ? 43 : ((Object)((Object)$versionFilter)).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        List<NPMPackage> $packages = this.getPackages();
        result = result * 59 + ($packages == null ? 43 : ((Object)$packages).hashCode());
        return result;
    }

    public String toString() {
        return "VersionsNPMRequest(versionFilter=" + (Object)((Object)this.getVersionFilter()) + ", mode=" + this.getMode() + ", packages=" + this.getPackages() + ", includeAll=" + this.isIncludeAll() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private VersionFilter versionFilter;
        private String mode;
        private List<NPMPackage> packages;
        private boolean includeAll;

        Builder() {
        }

        public Builder versionFilter(VersionFilter versionFilter) {
            this.versionFilter = versionFilter;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder packages(@NonNull List<NPMPackage> packages) {
            if (packages == null) {
                throw new NullPointerException("packages is marked non-null but is null");
            }
            this.packages = packages;
            return this;
        }

        public Builder includeAll(boolean includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public VersionsNPMRequest build() {
            return new VersionsNPMRequest(this.versionFilter, this.mode, this.packages, this.includeAll);
        }

        public String toString() {
            return "VersionsNPMRequest.Builder(versionFilter=" + (Object)((Object)this.versionFilter) + ", mode=" + this.mode + ", packages=" + this.packages + ", includeAll=" + this.includeAll + ")";
        }
    }

    public static enum VersionFilter {
        MAJOR_MINOR;

    }
}

