/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.reports.model.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.jboss.da.model.rest.NPMPackage;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class LookupNPMRequest {
    private final String versionSuffix;
    @NotNull
    private final String mode;
    @NonNull
    private final List<NPMPackage> packages;

    LookupNPMRequest(String versionSuffix, String mode, @NonNull List<NPMPackage> packages) {
        if (packages == null) {
            throw new NullPointerException("packages is marked non-null but is null");
        }
        this.versionSuffix = versionSuffix;
        this.mode = mode;
        this.packages = packages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVersionSuffix() {
        return this.versionSuffix;
    }

    public String getMode() {
        return this.mode;
    }

    @NonNull
    public List<NPMPackage> getPackages() {
        return this.packages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookupNPMRequest)) {
            return false;
        }
        LookupNPMRequest other = (LookupNPMRequest)o;
        String this$versionSuffix = this.getVersionSuffix();
        String other$versionSuffix = other.getVersionSuffix();
        if (this$versionSuffix == null ? other$versionSuffix != null : !this$versionSuffix.equals(other$versionSuffix)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        List<NPMPackage> this$packages = this.getPackages();
        List<NPMPackage> other$packages = other.getPackages();
        return !(this$packages == null ? other$packages != null : !((Object)this$packages).equals(other$packages));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $versionSuffix = this.getVersionSuffix();
        result = result * 59 + ($versionSuffix == null ? 43 : $versionSuffix.hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        List<NPMPackage> $packages = this.getPackages();
        result = result * 59 + ($packages == null ? 43 : ((Object)$packages).hashCode());
        return result;
    }

    public String toString() {
        return "LookupNPMRequest(versionSuffix=" + this.getVersionSuffix() + ", mode=" + this.getMode() + ", packages=" + this.getPackages() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String versionSuffix;
        private String mode;
        private List<NPMPackage> packages;

        Builder() {
        }

        public Builder versionSuffix(String versionSuffix) {
            this.versionSuffix = versionSuffix;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder packages(@NonNull List<NPMPackage> packages) {
            if (packages == null) {
                throw new NullPointerException("packages is marked non-null but is null");
            }
            this.packages = packages;
            return this;
        }

        public LookupNPMRequest build() {
            return new LookupNPMRequest(this.versionSuffix, this.mode, this.packages);
        }

        public String toString() {
            return "LookupNPMRequest.Builder(versionSuffix=" + this.versionSuffix + ", mode=" + this.mode + ", packages=" + this.packages + ")";
        }
    }
}

