/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.reports.model.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.jboss.da.model.rest.GAV;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LookupGAVsRequest {
    @NonNull
    private Set<String> productNames = new HashSet<String>();
    @NonNull
    private Set<Long> productVersionIds = new HashSet<Long>();
    @Deprecated
    private String repositoryGroup;
    private Boolean brewPullActive;
    @NotNull
    private String mode;
    private String versionSuffix;
    @NonNull
    private List<GAV> gavs;

    public LookupGAVsRequest(@NonNull Set<String> productNames, @NonNull Set<Long> productVersionIds, String repositoryGroup, Boolean brewPullActive, String mode, String versionSuffix, @NonNull List<GAV> gavs) {
        if (productNames == null) {
            throw new NullPointerException("productNames is marked non-null but is null");
        }
        if (productVersionIds == null) {
            throw new NullPointerException("productVersionIds is marked non-null but is null");
        }
        if (gavs == null) {
            throw new NullPointerException("gavs is marked non-null but is null");
        }
        this.productNames = productNames;
        this.productVersionIds = productVersionIds;
        this.repositoryGroup = repositoryGroup;
        this.brewPullActive = brewPullActive;
        this.mode = mode;
        this.versionSuffix = versionSuffix;
        this.gavs = gavs;
    }

    public LookupGAVsRequest() {
    }

    public LookupGAVsRequest(@NonNull List<GAV> gavs) {
        if (gavs == null) {
            throw new NullPointerException("gavs is marked non-null but is null");
        }
        this.gavs = gavs;
    }

    public String toString() {
        return "LookupGAVsRequest(productNames=" + this.getProductNames() + ", productVersionIds=" + this.getProductVersionIds() + ", repositoryGroup=" + this.getRepositoryGroup() + ", brewPullActive=" + this.getBrewPullActive() + ", mode=" + this.getMode() + ", versionSuffix=" + this.getVersionSuffix() + ", gavs=" + this.getGavs() + ")";
    }

    @NonNull
    public Set<String> getProductNames() {
        return this.productNames;
    }

    @NonNull
    public Set<Long> getProductVersionIds() {
        return this.productVersionIds;
    }

    @Deprecated
    public String getRepositoryGroup() {
        return this.repositoryGroup;
    }

    public Boolean getBrewPullActive() {
        return this.brewPullActive;
    }

    public String getMode() {
        return this.mode;
    }

    public String getVersionSuffix() {
        return this.versionSuffix;
    }

    @NonNull
    public List<GAV> getGavs() {
        return this.gavs;
    }
}

