/*
 * Decompiled with CFR 0.152.
 */
package org.goots.hiderdoclet.doclet;

import com.sun.source.util.DocTrees;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.internal.tool.DocEnvImpl;
import org.goots.slf4j.Logger;
import org.goots.slf4j.LoggerFactory;

public class DocletEnvironmentProcessor
extends DocEnvImpl
implements DocletEnvironment {
    private final Logger logger = LoggerFactory.getLogger(DocletEnvironmentProcessor.class);
    private final DocletEnvironment delegate;

    public DocletEnvironmentProcessor(DocletEnvironment environment) {
        super(((DocEnvImpl)environment).toolEnv, ((DocEnvImpl)environment).etable);
        this.delegate = environment;
    }

    @Override
    public Set<? extends Element> getSpecifiedElements() {
        return this.delegate.getSpecifiedElements();
    }

    @Override
    public Set<? extends Element> getIncludedElements() {
        HashSet<? extends Element> result = new HashSet<Element>(this.delegate.getIncludedElements());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (!this.checkForAnnotation(e)) continue;
            this.logger.info("Removing included element {}", (Object)e.getSimpleName());
            iterator.remove();
        }
        return result;
    }

    @Override
    public DocTrees getDocTrees() {
        return this.delegate.getDocTrees();
    }

    @Override
    public Elements getElementUtils() {
        return this.delegate.getElementUtils();
    }

    @Override
    public Types getTypeUtils() {
        return this.delegate.getTypeUtils();
    }

    @Override
    public boolean isIncluded(Element e) {
        if (this.checkForAnnotation(e)) {
            this.logger.info("Ignoring element {}", (Object)e.getSimpleName());
            return false;
        }
        return this.delegate.isIncluded(e);
    }

    @Override
    public boolean isSelected(Element e) {
        if (this.checkForAnnotation(e)) {
            this.logger.debug("Not selecting element {}", (Object)e.getSimpleName());
            return false;
        }
        return this.delegate.isSelected(e);
    }

    @Override
    public JavaFileManager getJavaFileManager() {
        return this.delegate.getJavaFileManager();
    }

    @Override
    public SourceVersion getSourceVersion() {
        return this.delegate.getSourceVersion();
    }

    @Override
    public DocletEnvironment.ModuleMode getModuleMode() {
        return this.delegate.getModuleMode();
    }

    @Override
    public JavaFileObject.Kind getFileKind(TypeElement type) {
        return this.delegate.getFileKind(type);
    }

    private boolean checkForAnnotation(Element e) {
        boolean result = false;
        if (e != null) {
            List<? extends AnnotationMirror> annotationMirrors = e.getAnnotationMirrors();
            if (annotationMirrors.stream().anyMatch(a -> a.getAnnotationType().toString().equals("org.goots.hiderdoclet.doclet.JavadocExclude"))) {
                result = true;
            }
            this.logger.debug("Looking for annotation in element {} and found {}", (Object)e.getSimpleName(), (Object)result);
        }
        return result;
    }
}

