/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.auth;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.commonjava.util.jhttpc.auth.ClientAuthenticator;
import org.commonjava.util.jhttpc.auth.PasswordKey;
import org.commonjava.util.jhttpc.auth.PasswordManager;
import org.commonjava.util.jhttpc.auth.PasswordType;
import org.commonjava.util.jhttpc.model.SiteConfig;

public class BasicAuthenticator
extends ClientAuthenticator {
    private PasswordManager passwords;

    public BasicAuthenticator(PasswordManager passwords) {
        this.passwords = passwords;
    }

    @Override
    public HttpClientContext decoratePrototypeContext(AuthScope scope, SiteConfig location, PasswordType type, HttpClientContext ctx) {
        CredentialsProvider creds = ctx.getCredentialsProvider();
        if (creds == null || !(creds instanceof BasicCredentialsProvider)) {
            creds = new BasicCredentialsProvider();
            ctx.setCredentialsProvider(creds);
        }
        if (PasswordType.USER == type) {
            String password = this.passwords.lookup(new PasswordKey(location, PasswordType.USER));
            creds.setCredentials(scope, new UsernamePasswordCredentials(location.getUser(), password));
        } else if (PasswordType.PROXY == type) {
            String password = this.passwords.lookup(new PasswordKey(location, PasswordType.PROXY));
            creds.setCredentials(scope, new UsernamePasswordCredentials(location.getProxyUser(), password));
        }
        return ctx;
    }
}

