/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.util;

import java.net.MalformedURLException;
import java.net.URL;

public final class UrlInfo {
    private final String url;
    private String user;
    private String password;
    private final String host;
    private int port;
    private final String rawUrl;

    public UrlInfo(String u) throws MalformedURLException {
        this(u, -1);
    }

    public UrlInfo(String u, int defaultPort) throws MalformedURLException {
        this.rawUrl = u;
        String resultUrl = u;
        URL url = new URL(u);
        String userInfo = url.getUserInfo();
        if (userInfo != null && this.user == null && this.password == null) {
            this.user = userInfo;
            this.password = null;
            int idx = userInfo.indexOf(58);
            if (idx > 0) {
                this.user = userInfo.substring(0, idx);
                this.password = userInfo.substring(idx + 1);
                StringBuilder sb = new StringBuilder();
                idx = this.rawUrl.indexOf("://");
                sb.append(this.rawUrl.substring(0, idx + 3));
                idx = this.rawUrl.indexOf("@");
                if (idx > 0) {
                    sb.append(this.rawUrl.substring(idx + 1));
                }
                resultUrl = sb.toString();
            }
        }
        this.url = resultUrl;
        this.host = url.getHost();
        this.port = url.getPort() < 0 ? (defaultPort > 0 ? defaultPort : url.getDefaultPort()) : url.getPort();
    }

    public String getRawUrl() {
        return this.rawUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

