/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.model;

import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;

public enum LocationTrustType {
    TRUST_SELF_SIGNED(new String[]{"self-signed", "trust-self-signed"}){

        @Override
        public TrustStrategy getTrustStrategy() {
            return new TrustSelfSignedStrategy();
        }
    }
    ,
    DEFAULT(new String[]{"default"}){

        @Override
        public TrustStrategy getTrustStrategy() {
            return null;
        }
    };

    private String[] aliases;

    private LocationTrustType(String ... aliases) {
        this.aliases = aliases;
    }

    public abstract TrustStrategy getTrustStrategy();

    public static LocationTrustType getType(String named) {
        for (LocationTrustType type : LocationTrustType.values()) {
            if (type.name().equalsIgnoreCase(named)) {
                return type;
            }
            for (String alias : type.aliases) {
                if (!alias.equalsIgnoreCase(named)) continue;
                return type;
            }
        }
        return DEFAULT;
    }
}

