/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.commonjava.maven.galley.TransferContentException;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.config.TransportMetricConfig;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.transport.DownloadJob;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.AbstractHttpJob;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.commonjava.maven.galley.transport.htcli.util.HttpUtil;
import org.commonjava.maven.galley.util.ResourceUtils;

public final class HttpDownload
extends AbstractHttpJob
implements DownloadJob {
    private final Transfer target;
    private Map<Transfer, Long> transferSizes;
    private final EventMetadata eventMetadata;
    private final ObjectMapper mapper;
    private boolean deleteFilesOnPath;
    private final MetricRegistry metricRegistry;
    private final TransportMetricConfig metricConfig;

    public HttpDownload(String url, HttpLocation location, Transfer target, Map<Transfer, Long> transferSizes, EventMetadata eventMetadata, Http http, ObjectMapper mapper, MetricRegistry metricRegistry, TransportMetricConfig metricConfig) {
        this(url, location, target, transferSizes, eventMetadata, http, mapper, true, metricRegistry, metricConfig);
    }

    public HttpDownload(String url, HttpLocation location, Transfer target, Map<Transfer, Long> transferSizes, EventMetadata eventMetadata, Http http, ObjectMapper mapper, boolean deleteFilesOnPath, MetricRegistry metricRegistry, TransportMetricConfig metricConfig) {
        super(url, location, http, new Integer[0]);
        this.target = target;
        this.transferSizes = transferSizes;
        this.eventMetadata = eventMetadata;
        this.mapper = mapper;
        this.deleteFilesOnPath = deleteFilesOnPath;
        this.metricRegistry = metricRegistry;
        this.metricConfig = metricConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadJob call() {
        if (this.metricConfig == null || !this.metricConfig.isEnabled() || this.metricRegistry == null) {
            return this.doCall();
        }
        this.logger.trace("Download metric enabled, location: {}", (Object)this.location);
        String cls = ClassUtils.getAbbreviatedName(this.getClass().getName(), 1);
        Timer repoTimer = null;
        String metricName = this.metricConfig.getMetricUniqueName(this.location);
        if (metricName != null) {
            repoTimer = this.metricRegistry.timer(MetricRegistry.name(this.metricConfig.getNodePrefix(), cls, "call", metricName));
            this.logger.trace("Measure repo metric, metricName: {}", (Object)metricName);
        }
        Timer globalTimer = this.metricRegistry.timer(MetricRegistry.name(this.metricConfig.getNodePrefix(), cls, "call"));
        Timer.Context globalTimerContext = globalTimer.time();
        Timer.Context repoTimerContext = null;
        if (repoTimer != null) {
            repoTimerContext = repoTimer.time();
        }
        try {
            DownloadJob downloadJob = this.doCall();
            return downloadJob;
        }
        finally {
            globalTimerContext.stop();
            if (repoTimerContext != null) {
                repoTimerContext.stop();
            }
        }
    }

    private DownloadJob doCall() {
        this.request = new HttpGet(this.url);
        String oldName = Thread.currentThread().getName();
        try {
            String newName = oldName + ": GET " + this.url;
            Thread.currentThread().setName(newName);
            if (this.executeHttp()) {
                this.transferSizes.put(this.target, HttpUtil.getContentLength(this.response));
                this.writeTarget();
            }
        }
        catch (TransferException e) {
            this.error = e;
        }
        finally {
            this.cleanup();
            if (oldName != null) {
                Thread.currentThread().setName(oldName);
            }
        }
        this.logger.info("Download attempt done: {} Result:\n  target: {}\n  error: {}", this.url, this.target, this.error);
        return this;
    }

    @Override
    protected ObjectMapper getMetadataObjectMapper() {
        return this.mapper;
    }

    @Override
    public long getTransferSize() {
        return this.response == null ? -1L : HttpUtil.getContentLength(this.response);
    }

    @Override
    public TransferException getError() {
        return this.error;
    }

    @Override
    public Transfer getTransfer() {
        if (this.eventMetadata.get("storage-path") != null) {
            this.target.setResource(ResourceUtils.storageResource(this.target.getResource(), this.eventMetadata));
        }
        return this.target;
    }

    private void writeTarget() throws TransferException {
        OutputStream out = null;
        if (this.response != null) {
            InputStream in = null;
            try {
                HttpEntity entity = this.response.getEntity();
                in = entity.getContent();
                out = this.target.openOutputStream(TransferOperation.DOWNLOAD, true, this.eventMetadata, this.deleteFilesOnPath);
                this.doCopy(in, out);
                this.logger.info("Ensuring all HTTP data is consumed...");
                this.closeAllQuietly(in, out);
            }
            catch (IOException eOrig) {
                try {
                    this.closeAllQuietly(in, out);
                    ConcreteResource resource = this.target.getResource();
                    try {
                        this.logger.debug("Failed to write to local proxy store:{}. Deleting partial target file:{}", (Object)eOrig, (Object)this.target.getPath());
                        this.target.delete();
                    }
                    catch (IOException eDel) {
                        this.logger.error(String.format("Failed to delete target file: %s\nOriginal URL: %s. Reason: %s", this.target, this.url, eDel.getMessage()), eDel);
                    }
                    this.logger.error(String.format("Failed to write to local proxy store: %s\nOriginal URL: %s. Reason: %s", this.target, this.url, eOrig.getMessage()), eOrig);
                    throw new TransferContentException(resource, "Failed to write to local proxy store: %s\nOriginal URL: %s. Reason: %s", eOrig, this.target, this.url, eOrig.getMessage());
                }
                catch (Throwable throwable) {
                    this.closeAllQuietly(in, out);
                    throw throwable;
                }
            }
        }
    }

    private void doCopy(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllQuietly(InputStream in, OutputStream out) {
        try {
            EntityUtils.consume(this.response.getEntity());
            this.logger.info("All HTTP data was consumed.");
        }
        catch (IOException e) {
            this.logger.error("Failed to consume remainder HTTP response entity data", e);
        }
        finally {
            IOUtils.closeQuietly(in);
            this.logger.info("Closing output stream: {}", (Object)out);
            IOUtils.closeQuietly(out);
        }
    }
}

