/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli;

import java.io.Closeable;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.commonjava.maven.galley.GalleyException;
import org.commonjava.maven.galley.TransferLocationException;
import org.commonjava.maven.galley.auth.PasswordEntry;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.spi.auth.PasswordManager;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.util.HttpFactoryPasswordDelegate;
import org.commonjava.maven.galley.transport.htcli.internal.util.LocationLookup;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.commonjava.maven.galley.transport.htcli.util.HttpUtil;
import org.commonjava.maven.galley.util.LocationUtils;
import org.commonjava.util.jhttpc.HttpFactory;
import org.commonjava.util.jhttpc.JHttpCException;
import org.commonjava.util.jhttpc.model.SiteConfig;
import org.commonjava.util.jhttpc.model.SiteConfigBuilder;
import org.commonjava.util.jhttpc.model.SiteTrustType;

@ApplicationScoped
public class HttpImpl
implements Http,
Closeable {
    private final PasswordManager passwords;
    private final HttpFactory httpFactory;
    private final LocationLookup locationLookup;

    public HttpImpl(PasswordManager passwords) {
        this.passwords = passwords;
        this.locationLookup = new LocationLookup();
        this.httpFactory = new HttpFactory(new HttpFactoryPasswordDelegate(passwords, this.locationLookup));
    }

    @Override
    public CloseableHttpClient createClient() throws GalleyException {
        return this.createClient(null);
    }

    @Override
    public CloseableHttpClient createClient(HttpLocation location) throws GalleyException {
        try {
            if (location != null) {
                this.locationLookup.register(location);
                int maxConnections = LocationUtils.getMaxConnections(location);
                SiteConfigBuilder configBuilder = new SiteConfigBuilder(location.getName(), location.getUri());
                configBuilder.withAttributes(location.getAttributes()).withKeyCertPem(location.getKeyCertPem()).withServerCertPem(location.getServerCertPem()).withProxyHost(location.getProxyHost()).withProxyPort(location.getProxyPort()).withProxyUser(location.getProxyUser()).withRequestTimeoutSeconds(LocationUtils.getTimeoutSeconds(location)).withUser(location.getUser()).withIgnoreHostnameVerification(location.isIgnoreHostnameVerification()).withMaxConnections(maxConnections);
                if (location.getTrustType() != null) {
                    configBuilder.withTrustType(SiteTrustType.getType(location.getTrustType().name()));
                }
                SiteConfig config = configBuilder.build();
                return this.httpFactory.createClient(config);
            }
            return this.httpFactory.createClient();
        }
        catch (JHttpCException e) {
            throw new TransferLocationException((Location)location, "Failed to initialize http client: %s", e, e.getMessage());
        }
    }

    private int getProxyPort(HttpLocation location) {
        int port = location.getProxyPort();
        if (port < 1) {
            port = -1;
        }
        return port;
    }

    @Override
    public HttpClientContext createContext() {
        return this.createContext(null);
    }

    @Override
    public HttpClientContext createContext(HttpLocation location) {
        HttpClientContext ctx = HttpClientContext.create();
        if (location != null) {
            String password;
            BasicCredentialsProvider creds = new BasicCredentialsProvider();
            AuthScope as = new AuthScope(location.getHost(), location.getPort());
            if (location.getUser() != null) {
                password = this.passwords.getPassword(new PasswordEntry(location, "USER"));
                creds.setCredentials(as, new UsernamePasswordCredentials(location.getUser(), password));
            }
            if (location.getProxyHost() != null && location.getProxyUser() != null) {
                password = this.passwords.getPassword(new PasswordEntry(location, "PROXY"));
                creds.setCredentials(new AuthScope(location.getProxyHost(), this.getProxyPort(location)), new UsernamePasswordCredentials(location.getProxyUser(), password));
            }
            ctx.setCredentialsProvider(creds);
        }
        return ctx;
    }

    @Override
    public void cleanup(CloseableHttpClient client, HttpUriRequest request, CloseableHttpResponse response) {
        HttpUtil.cleanupResources(client, request, response);
    }

    @Override
    public void close() throws IOException {
    }
}

