/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;

@ApplicationScoped
public class TransportManagerImpl
implements TransportManager {
    @Inject
    private Instance<Transport> injected;
    private List<Transport> transports;

    protected TransportManagerImpl() {
    }

    public TransportManagerImpl(Transport ... transports) {
        this.transports = new ArrayList<Transport>(Arrays.asList(transports));
    }

    public TransportManagerImpl(List<Transport> transports) {
        this.transports = transports;
    }

    @PostConstruct
    protected void setup() {
        ArrayList<Transport> transports = new ArrayList<Transport>();
        if (this.injected != null) {
            for (Transport transport : this.injected) {
                transports.add(transport);
            }
        }
        this.transports = transports;
    }

    @Override
    public Transport getTransport(Location location) throws TransferException {
        for (Transport t : this.transports) {
            if (!t.handles(location)) continue;
            return t;
        }
        return null;
    }

    @Override
    public Transport getTransport(ConcreteResource resource) throws TransferException {
        return this.getTransport(resource.getLocation());
    }
}

