/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.spi.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Transfer;

public interface CacheProvider {
    public static final String SUFFIX_TO_DELETE = ".to-delete";
    public static final String SUFFIX_TO_WRITE = ".to-write";
    public static final String STORAGE_PATH = "storage-path";
    public static final String STORE_HTTP_HEADERS = "store-http-headers";
    public static final Set<String> HIDDEN_SUFFIXES = Collections.unmodifiableSet(new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(CacheProvider.SUFFIX_TO_DELETE);
            this.add(CacheProvider.SUFFIX_TO_WRITE);
        }
    });

    public void startReporting();

    public void stopReporting();

    public void cleanupCurrentThread();

    public boolean isDirectory(ConcreteResource var1);

    public boolean isFile(ConcreteResource var1);

    public InputStream openInputStream(ConcreteResource var1) throws IOException;

    public OutputStream openOutputStream(ConcreteResource var1) throws IOException;

    public boolean exists(ConcreteResource var1);

    public void copy(ConcreteResource var1, ConcreteResource var2) throws IOException;

    public String getFilePath(ConcreteResource var1);

    public boolean delete(ConcreteResource var1) throws IOException;

    public String[] list(ConcreteResource var1);

    public void mkdirs(ConcreteResource var1) throws IOException;

    @Deprecated
    public void createFile(ConcreteResource var1) throws IOException;

    @Deprecated
    public void createAlias(ConcreteResource var1, ConcreteResource var2) throws IOException;

    public Transfer getTransfer(ConcreteResource var1);

    public void clearTransferCache();

    public long length(ConcreteResource var1);

    public long lastModified(ConcreteResource var1);

    public boolean isReadLocked(ConcreteResource var1);

    public boolean isWriteLocked(ConcreteResource var1);

    public void unlockRead(ConcreteResource var1);

    public void unlockWrite(ConcreteResource var1);

    public void lockRead(ConcreteResource var1);

    public void lockWrite(ConcreteResource var1);

    public void waitForWriteUnlock(ConcreteResource var1);

    public void waitForReadUnlock(ConcreteResource var1);

    public AdminView asAdminView();

    public static interface AdminView
    extends CacheProvider {
        public boolean isFileBased();

        public File getDetachedFile(ConcreteResource var1);
    }
}

