/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io.checksum;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.commonjava.maven.galley.io.checksum.ContentDigest;

public class TransferMetadata
implements Externalizable {
    private Map<ContentDigest, String> digests;
    private Long size;

    public TransferMetadata() {
    }

    public TransferMetadata(Map<ContentDigest, String> digests, Long size) {
        this.digests = digests;
        this.size = size;
    }

    public Map<ContentDigest, String> getDigests() {
        return this.digests;
    }

    public Long getSize() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.size);
        objectOutput.writeObject(this.digests);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.size = objectInput.readLong();
        this.digests = (Map)objectInput.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransferMetadata: {");
        sb.append("\n  size: ").append(this.size);
        sb.append("\n  digests: {");
        for (Map.Entry<ContentDigest, String> entry : this.digests.entrySet()) {
            sb.append("\n    ").append((Object)entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("\n  }\n}");
        return sb.toString();
    }
}

