/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io.checksum;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGenerator;
import org.commonjava.maven.galley.io.checksum.AbstractChecksumGeneratorFactory;
import org.commonjava.maven.galley.io.checksum.ContentDigest;
import org.commonjava.maven.galley.io.checksum.TransferMetadata;
import org.commonjava.maven.galley.io.checksum.TransferMetadataConsumer;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChecksummingInputStream
extends FilterInputStream {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<AbstractChecksumGenerator> checksums;
    private long size = 0L;
    private final Transfer transfer;
    private final TransferMetadataConsumer metadataConsumer;
    private boolean writeChecksumFiles;

    public ChecksummingInputStream(Set<AbstractChecksumGeneratorFactory<?>> checksumFactories, InputStream stream, Transfer transfer, TransferMetadataConsumer metadataConsumer, boolean writeChecksumFiles) throws IOException {
        super(stream);
        this.transfer = transfer;
        this.metadataConsumer = metadataConsumer;
        this.writeChecksumFiles = writeChecksumFiles;
        this.checksums = new HashSet<AbstractChecksumGenerator>();
        for (AbstractChecksumGeneratorFactory<?> factory : checksumFactories) {
            this.checksums.add((AbstractChecksumGenerator)factory.createGenerator(transfer, writeChecksumFiles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.logger.trace("START CLOSE: {}", (Object)this.transfer);
            this.logger.trace("Read done: {} in: {}. Now, creating checksums.", (Object)this.transfer.getPath(), (Object)this.transfer.getLocation());
            HashMap<ContentDigest, String> hexDigests = new HashMap<ContentDigest, String>();
            for (AbstractChecksumGenerator checksum : this.checksums) {
                hexDigests.put(checksum.getDigestType(), checksum.getDigestHex());
                if (!this.writeChecksumFiles) continue;
                this.logger.trace("Writing checksum file for: {}", (Object)checksum.getDigestType());
                checksum.write();
            }
            if (this.metadataConsumer != null) {
                this.logger.trace("Adding metadata for: {} to: {}", (Object)this.transfer, (Object)this.metadataConsumer);
                this.metadataConsumer.addMetadata(this.transfer, new TransferMetadata(hexDigests, this.size));
            } else {
                this.logger.trace("No metadata consumer. NOT adding metadata.");
            }
        }
        finally {
            super.close();
            this.logger.trace("END CLOSE: {}", (Object)this.transfer);
        }
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        this.logger.trace("{} input", (Object)data);
        if (data > -1) {
            ++this.size;
            for (AbstractChecksumGenerator checksum : this.checksums) {
                checksum.update((byte)data);
            }
        }
        return data;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.updateDigests(b, off, read);
        return read;
    }

    private void updateDigests(byte[] b, int off, int read) {
        if (read < 0) {
            return;
        }
        this.size += (long)read;
        for (AbstractChecksumGenerator checksum : this.checksums) {
            for (int i = off; i < off + read; ++i) {
                checksum.update((byte)(b[i] & 0xFF));
            }
        }
    }
}

