/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.io.checksum;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.commonjava.maven.galley.io.checksum.ContentDigest;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChecksumGenerator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MessageDigest digester;
    private final String checksumExtension;
    private ContentDigest digestType;
    private final boolean writeChecksumFile;
    private final Transfer checksumTransfer;
    private String digestHex;

    protected AbstractChecksumGenerator(Transfer transfer, String checksumExtension, ContentDigest type, boolean writeChecksumFile) throws IOException {
        this.checksumExtension = checksumExtension;
        this.digestType = type;
        this.writeChecksumFile = writeChecksumFile;
        try {
            this.digester = MessageDigest.getInstance(this.digestType.digestName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Cannot get MessageDigest for checksum type: '" + (Object)((Object)type) + "': " + e.getMessage(), e);
        }
        if (writeChecksumFile) {
            this.logger.debug("Getting checksum transfer for: {}", (Object)transfer);
            this.checksumTransfer = this.getChecksumFile(transfer);
            this.logger.debug("Locking checksum file: {}", (Object)this.checksumTransfer);
            this.checksumTransfer.lockWrite();
        } else {
            this.checksumTransfer = null;
        }
    }

    public final void update(byte[] data) {
        this.digester.update(data);
    }

    public final void update(byte data) {
        this.digester.update(data);
    }

    public final void write() throws IOException {
        if (!this.writeChecksumFile) {
            return;
        }
        this.logger.info("Writing {} file: {}", (Object)this.checksumExtension, (Object)this.checksumTransfer);
        PrintStream out = null;
        OutputStream stream = null;
        try {
            stream = this.checksumTransfer.openOutputStream(TransferOperation.GENERATE);
            out = new PrintStream(stream);
            out.print(this.getDigestHex());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(stream);
    }

    public synchronized String getDigestHex() {
        if (this.digestHex == null) {
            this.digestHex = Hex.encodeHexString(this.digester.digest());
        }
        return this.digestHex;
    }

    public final void delete() throws IOException {
        if (this.checksumTransfer.exists()) {
            this.checksumTransfer.delete();
            this.checksumTransfer.unlock();
        }
    }

    private Transfer getChecksumFile(Transfer transfer) {
        return transfer.getSiblingMeta(this.checksumExtension);
    }

    public ContentDigest getDigestType() {
        return this.digestType;
    }
}

