/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kong.unirest.GenericType;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.json.DependencyAnalyserResult;
import org.commonjava.maven.ext.common.json.ErrorMessage;
import org.commonjava.maven.ext.common.util.GAVUtils;
import org.commonjava.maven.ext.common.util.JSONUtils;
import org.commonjava.maven.ext.common.util.ListUtils;
import org.commonjava.maven.ext.io.rest.RestException;
import org.commonjava.maven.ext.io.rest.Translator;
import org.jboss.da.lookup.model.MavenLatestRequest;
import org.jboss.da.lookup.model.MavenLookupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTranslator
implements Translator {
    private static final GenericType<List<DependencyAnalyserResult>> lookupType = new GenericType<List<DependencyAnalyserResult>>(){};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String endpointUrl;
    private final int initialRestMaxSize;
    private final int initialRestMinSize;
    private final Boolean brewPullActive;
    private final String mode;
    private final Map<String, String> restHeaders;
    private final int retryDuration;
    private final int restConnectionTimeout;
    private final int restSocketTimeout;

    public DefaultTranslator(String endpointUrl, int restMaxSize, int restMinSize, Boolean brewPullActive, String mode, Map<String, String> restHeaders, int restConnectionTimeout, int restSocketTimeout, int restRetryDuration) {
        this.brewPullActive = brewPullActive;
        this.mode = mode;
        this.endpointUrl = endpointUrl + (StringUtils.isNotBlank(endpointUrl) ? (endpointUrl.endsWith("/") ? "" : "/") : "");
        this.initialRestMaxSize = restMaxSize;
        this.initialRestMinSize = restMinSize;
        this.restHeaders = restHeaders;
        this.restConnectionTimeout = restConnectionTimeout;
        this.restSocketTimeout = restSocketTimeout;
        this.retryDuration = restRetryDuration;
    }

    @Override
    public Map<ProjectVersionRef, String> lookupVersions(List<ProjectVersionRef> p) throws RestException {
        return this.internalLookup(Endpoint.LOOKUP_GAVS, p);
    }

    @Override
    public Map<ProjectVersionRef, String> lookupProjectVersions(List<ProjectVersionRef> p) throws RestException {
        return this.internalLookup(Endpoint.LOOKUP_LATEST, p);
    }

    private void partition(Endpoint endpointType, List<ProjectVersionRef> projects, Queue<Task> queue) {
        if (this.initialRestMaxSize != 0) {
            if (this.initialRestMaxSize == -1) {
                this.autoPartition(endpointType, projects, queue);
            } else {
                this.userDefinedPartition(endpointType, projects, queue);
            }
        } else {
            this.noOpPartition(endpointType, projects, queue);
        }
    }

    private void noOpPartition(Endpoint endpointType, List<ProjectVersionRef> projects, Queue<Task> queue) {
        this.logger.info("Using NO-OP partition strategy");
        queue.add(new Task(projects, this.endpointUrl, endpointType));
    }

    private void userDefinedPartition(Endpoint endpointType, List<ProjectVersionRef> projects, Queue<Task> queue) {
        this.logger.info("Using user defined partition strategy");
        List<List<ProjectVersionRef>> partition = ListUtils.partition(projects, this.initialRestMaxSize);
        for (List<ProjectVersionRef> p : partition) {
            queue.add(new Task(p, this.endpointUrl, endpointType));
        }
        this.logger.debug("For initial sizing of {} have split the queue into {}", (Object)this.initialRestMaxSize, (Object)queue.size());
    }

    private void autoPartition(Endpoint endpointType, List<ProjectVersionRef> projects, Queue<Task> queue) {
        List<List<ProjectVersionRef>> partition;
        if (projects.size() < 600) {
            this.logger.info("Using auto partition strategy: {} projects divided in chunks with {} each", (Object)projects.size(), (Object)128);
            partition = ListUtils.partition(projects, 128);
        } else if (projects.size() > 600 && projects.size() < 1200) {
            this.logger.info("Using auto partition strategy: {} projects divided in chunks with {} each", (Object)projects.size(), (Object)64);
            partition = ListUtils.partition(projects, 64);
        } else {
            this.logger.info("Using auto partition strategy: {} projects divided in chunks with {} each", (Object)projects.size(), (Object)32);
            partition = ListUtils.partition(projects, 32);
        }
        for (List<ProjectVersionRef> p : partition) {
            queue.add(new Task(p, this.endpointUrl, endpointType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ProjectVersionRef, String> internalLookup(Endpoint endpointType, List<ProjectVersionRef> p) throws RestException {
        List<ProjectVersionRef> projects = p.stream().distinct().collect(Collectors.toList());
        if (p.size() != projects.size()) {
            this.logger.debug("Eliminating duplicates from {} resulting in {}", (Object)p, (Object)projects);
        }
        this.logger.info("Calling REST client... (with {} GAVs)", (Object)projects.size());
        ArrayDeque<Task> queue = new ArrayDeque<Task>();
        HashMap<ProjectVersionRef, String> result = new HashMap<ProjectVersionRef, String>();
        long start = System.nanoTime();
        boolean finishedSuccessfully = false;
        try {
            this.partition(endpointType, projects, queue);
            while (!queue.isEmpty()) {
                Task task = (Task)queue.remove();
                task.executeTranslate();
                if (task.isSuccess()) {
                    result.putAll(task.getResult());
                    continue;
                }
                if (task.canSplit() && this.isRecoverable(task.getStatus())) {
                    if (task.getStatus() == 503) {
                        this.logger.info("The DA server is unavailable. Waiting {} before splitting the tasks and retrying", (Object)this.retryDuration);
                        this.waitBeforeRetry(this.retryDuration);
                    }
                    List<Task> tasks = task.split(endpointType);
                    this.logger.warn("Failed to translate versions for task @{} due to {}, splitting and retrying. Chunk size was: {} and new chunk size {} in {} segments.", task.hashCode(), task.getStatus(), task.getChunkSize(), tasks.get(0).getChunkSize(), tasks.size());
                    queue.addAll(tasks);
                    continue;
                }
                if (task.getStatus() < 0) {
                    this.logger.debug("Caught exception calling server with message {}", (Object)task.getErrorMessage());
                } else {
                    this.logger.debug("Did not get status {} but received {}", (Object)200, (Object)task.getStatus());
                }
                throw new RestException("Received response status {} with message: {}", task.getStatus(), task.getErrorMessage());
            }
            finishedSuccessfully = true;
        }
        finally {
            DefaultTranslator.printFinishTime(this.logger, start, finishedSuccessfully);
        }
        return result;
    }

    private boolean isRecoverable(int httpErrorCode) {
        return httpErrorCode == 504 || httpErrorCode == 503;
    }

    private void waitBeforeRetry(int seconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
        }
        catch (InterruptedException e) {
            this.logger.error("Caught exception while waiting", e);
        }
    }

    private static void printFinishTime(Logger logger, long start, boolean finished) {
        long finish = System.nanoTime();
        long minutes = TimeUnit.NANOSECONDS.toMinutes(finish - start);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(finish - start) - minutes * 60L;
        logger.info("REST client finished {}... (took {} min, {} sec, {} millisec)", finished ? "successfully" : "with failures", minutes, seconds, TimeUnit.NANOSECONDS.toMillis(finish - start) - minutes * 60L * 1000L - seconds * 1000L);
    }

    static {
        Unirest.config().socketTimeout(600000).connectTimeout(30000).setObjectMapper(new JSONUtils.InternalObjectMapper(new ObjectMapper()));
    }

    private class Task {
        private final List<ProjectVersionRef> chunk;
        private final String endpointUrl;
        private final Endpoint endpointType;
        private Map<ProjectVersionRef, String> result = Collections.emptyMap();
        private int status = -1;
        private Exception exception;
        private String errorString;

        Task(List<ProjectVersionRef> chunk, String endpointUrl, Endpoint endpointType) {
            this.chunk = chunk;
            this.endpointUrl = endpointUrl;
            this.endpointType = endpointType;
        }

        void executeTranslate() {
            try {
                boolean lookup = this.endpointType == Endpoint.LOOKUP_GAVS;
                MavenLatestRequest request = lookup ? MavenLookupRequest.builder().mode(DefaultTranslator.this.mode).brewPullActive(DefaultTranslator.this.brewPullActive).artifacts(GAVUtils.generateGAVs(this.chunk)).build() : MavenLatestRequest.builder().mode(DefaultTranslator.this.mode).artifacts(GAVUtils.generateGAVs(this.chunk)).build();
                HttpResponse r = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post(this.endpointUrl + (Object)((Object)this.endpointType)).header("accept", "application/json")).header("Content-Type", "application/json")).headers(DefaultTranslator.this.restHeaders)).connectTimeout(DefaultTranslator.this.restConnectionTimeout * 1000)).socketTimeout(DefaultTranslator.this.restSocketTimeout * 1000)).body(request).asObject(lookupType).ifSuccess(successResponse -> {
                    this.result = ((List)successResponse.getBody()).stream().filter(f -> lookup ? StringUtils.isNotBlank(f.getBestMatchVersion()) : StringUtils.isNotBlank(f.getLatestVersion())).collect(Collectors.toMap(DependencyAnalyserResult::getProjectVersionRef, lookup ? DependencyAnalyserResult::getBestMatchVersion : DependencyAnalyserResult::getLatestVersion, (o, n) -> {
                        DefaultTranslator.this.logger.warn("Located duplicate key {}", o);
                        return o;
                    }));
                }).ifFailure(failedResponse -> {
                    if (!failedResponse.getParsingError().isPresent()) {
                        DefaultTranslator.this.logger.debug("Parsing error but no message. Status text {}", (Object)failedResponse.getStatusText());
                        throw new ManipulationUncheckedException(failedResponse.getStatusText(), new Object[0]);
                    }
                    String originalBody = failedResponse.getParsingError().get().getOriginalBody();
                    if (originalBody.isEmpty()) {
                        this.errorString = "No content to read.";
                    } else if (originalBody.startsWith("<")) {
                        String stripped = originalBody.replaceAll("<.*?>", "").replaceAll("\n", " ").trim();
                        DefaultTranslator.this.logger.debug("Read HTML string '{}' rather than a JSON stream; stripping message to '{}'", (Object)originalBody, (Object)stripped);
                        this.errorString = stripped;
                    } else if (originalBody.startsWith("{\"")) {
                        this.errorString = failedResponse.mapError(ErrorMessage.class).toString();
                        DefaultTranslator.this.logger.debug("Read message string {}, processed to {}", (Object)originalBody, (Object)this.errorString);
                    } else if (originalBody.startsWith("javax.validation.ValidationException: ")) {
                        this.errorString = originalBody;
                    } else {
                        DefaultTranslator.this.logger.error("HTTP comm failure: {}", (Object)failedResponse.getParsingError().get().getMessage());
                        throw new ManipulationUncheckedException("Problem in HTTP communication with status code {} and message {}", failedResponse.getStatus(), failedResponse.getStatusText());
                    }
                });
                this.status = r.getStatus();
            }
            catch (UnirestException | ManipulationUncheckedException e) {
                this.exception = e;
                this.status = -1;
            }
        }

        public List<Task> split(Endpoint endpointType) {
            ArrayList<Task> res = new ArrayList<Task>(4);
            if (this.chunk.size() >= 4) {
                int chunkSize = this.chunk.size() / 4;
                for (int i = 0; i < 3; ++i) {
                    res.add(new Task(this.chunk.subList(i * chunkSize, (i + 1) * chunkSize), this.endpointUrl, endpointType));
                }
                res.add(new Task(this.chunk.subList(3 * chunkSize, this.chunk.size()), this.endpointUrl, endpointType));
            } else {
                for (int i = 0; i < this.chunk.size() - DefaultTranslator.this.initialRestMinSize + 1; ++i) {
                    res.add(new Task(this.chunk.subList(i * DefaultTranslator.this.initialRestMinSize, (i + 1) * DefaultTranslator.this.initialRestMinSize), this.endpointUrl, endpointType));
                }
            }
            return res;
        }

        boolean canSplit() {
            return this.chunk.size() / DefaultTranslator.this.initialRestMinSize > 0 && this.chunk.size() != 1;
        }

        int getStatus() {
            return this.status;
        }

        boolean isSuccess() {
            return this.status == 200;
        }

        public Map<ProjectVersionRef, String> getResult() {
            return this.result;
        }

        String getErrorMessage() {
            return (this.exception != null ? this.exception.getMessage() + ' ' : "") + (this.errorString != null ? this.errorString : "");
        }

        int getChunkSize() {
            return this.chunk.size();
        }
    }

    public static enum Endpoint {
        LOOKUP_GAVS("lookup/maven"),
        LOOKUP_LATEST("lookup/maven/latest");

        private final String endpoint;

        private Endpoint(String s) {
            this.endpoint = s;
        }

        public String toString() {
            return this.endpoint;
        }

        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

