/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.util.LineSeparator;
import org.commonjava.maven.ext.io.resolver.GalleyInfrastructure;

@Named
@Singleton
public class FileIO {
    private final GalleyInfrastructure infra;

    @Inject
    public FileIO(@Named(value="galley") GalleyInfrastructure infra) {
        this.infra = infra;
    }

    public File resolveURL(String reference) throws IOException {
        File result;
        URL ref = SystemUtils.IS_OS_WINDOWS ? new URL(reference.replaceFirst("^file://([a-zA-Z]:\\\\)", "file:///$1")) : new URL(reference);
        if (!"file".equals(ref.getProtocol())) {
            File cache = this.infra.getCacheDir();
            result = new File(cache, UUID.randomUUID().toString());
            FileUtils.copyURLToFile(ref, result);
        } else {
            result = new File(ref.getPath());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LineSeparator determineEOL(File file) throws ManipulationException {
        try (BufferedReader bufferIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            int ch;
            int prev = -1;
            while ((ch = bufferIn.read()) != -1) {
                if (ch == 10) {
                    if (prev == 13) {
                        LineSeparator lineSeparator = LineSeparator.CRNL;
                        return lineSeparator;
                    }
                    LineSeparator lineSeparator = LineSeparator.NL;
                    return lineSeparator;
                }
                if (prev == 13) {
                    LineSeparator lineSeparator = LineSeparator.CR;
                    return lineSeparator;
                }
                prev = ch;
            }
            throw new ManipulationException("Could not determine end-of-line marker mode", new Object[0]);
        }
        catch (IOException ioe) {
            throw new ManipulationException("Could not determine end-of-line marker mode", ioe);
        }
    }
}

