/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Version;
import org.commonjava.maven.ext.core.state.CommonState;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.core.util.PropertyMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtils.class);

    private PropertiesUtils() {
    }

    public static Map<String, String> getPropertiesByPrefix(Properties properties, String prefix) {
        HashMap<String, String> matchedProperties = new HashMap<String, String>();
        int prefixLength = prefix.length();
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(prefix)) continue;
            String trimmedPropertyName = propertyName.substring(prefixLength);
            String value = properties.getProperty(propertyName);
            if ("true".equals(value)) {
                logger.warn("Work around Brew/Maven bug - removing erroneous 'true' value for {}.", (Object)trimmedPropertyName);
                value = "";
            }
            matchedProperties.put(trimmedPropertyName, value);
        }
        return matchedProperties;
    }

    public static PropertyUpdate updateProperties(ManipulationSession session, Project project, boolean ignoreStrict, String key, String newValue) throws ManipulationException {
        String resolvedValue = PropertyResolver.resolveProperties(session, project.getInheritedList(), "${" + key + '}');
        logger.debug("Fully resolvedValue is {} for {}", (Object)resolvedValue, (Object)key);
        if ("project.version".equals(key)) {
            logger.debug("Not updating key {} with {}", (Object)key, (Object)newValue);
            return PropertyUpdate.IGNORE;
        }
        for (Project p : project.getReverseInheritedList()) {
            if (p.getModel().getProperties().containsKey(key)) {
                logger.trace("Searching properties of {}", (Object)p);
                return PropertiesUtils.internalUpdateProperty(session, p, ignoreStrict, key, newValue, resolvedValue, p.getModel().getProperties());
            }
            for (Profile pr : ProfileUtils.getProfiles(session, p.getModel())) {
                logger.trace("Searching properties of profile {} within project {}", (Object)pr.getId(), (Object)p);
                if (!pr.getProperties().containsKey(key)) continue;
                return PropertiesUtils.internalUpdateProperty(session, p, ignoreStrict, key, newValue, resolvedValue, pr.getProperties());
            }
        }
        return PropertyUpdate.NOTFOUND;
    }

    private static PropertyUpdate internalUpdateProperty(ManipulationSession session, Project p, boolean ignoreStrict, String key, String newValue, String resolvedValue, Properties props) throws ManipulationException {
        CommonState state = session.getState(CommonState.class);
        String oldValue = props.getProperty(key);
        logger.debug("Examining property {} / {} (resolved {}) with {}", key, oldValue, resolvedValue, newValue);
        PropertyUpdate found = PropertyUpdate.FOUND;
        if (StringUtils.startsWith(oldValue, "${") && StringUtils.endsWith(oldValue, "}") && StringUtils.countMatches(oldValue, "${") <= 1) {
            String newKey = oldValue.substring(2, oldValue.length() - 1);
            logger.debug("Recursively resolving {}", (Object)newKey);
            if (PropertiesUtils.updateProperties(session, p, ignoreStrict, newKey, newValue) == PropertyUpdate.NOTFOUND) {
                logger.error("Recursive property not found for {} with {}", (Object)oldValue, (Object)newValue);
                return PropertyUpdate.NOTFOUND;
            }
        } else {
            if (state.isStrict() && !ignoreStrict && !PropertiesUtils.checkStrictValue(session, resolvedValue, newValue)) {
                if (state.isFailOnStrictViolation()) {
                    throw new ManipulationException("Replacing original property version {} (fully resolved: {} ) with new version {} for {} violates the strict version-alignment rule!", oldValue, resolvedValue, newValue, key);
                }
                logger.warn("Replacing original property version {} with new version {} for {} violates the strict version-alignment rule!", oldValue, newValue, key);
                return found;
            }
            if (StringUtils.contains(oldValue, "${") && (!StringUtils.startsWith(oldValue, "${") || !StringUtils.endsWith(oldValue, "}")) || StringUtils.countMatches(oldValue, "${") > 1) {
                if (ignoreStrict) {
                    throw new ManipulationException("NYI : handling for versions with explicit overrides ({}) with multiple embedded properties is NYI. ", oldValue);
                }
                if (resolvedValue.equals(newValue)) {
                    logger.warn("Nothing to update as original key {} value matches new value {}", (Object)key, (Object)newValue);
                    found = PropertyUpdate.IGNORE;
                }
                newValue = oldValue + StringUtils.removeStart(newValue, resolvedValue);
                logger.info("Ignoring new value due to embedded property {} and appending {}", (Object)oldValue, (Object)newValue);
            }
            props.setProperty(key, newValue);
        }
        return found;
    }

    public static String getSuffix(ManipulationSession session) {
        return session.getState(VersioningState.class).getRebuildSuffix();
    }

    public static boolean checkStrictValue(ManipulationSession session, String oldValue, String newValue) {
        if (oldValue == null || newValue == null) {
            return false;
        }
        if (oldValue.equals(newValue)) {
            return true;
        }
        CommonState cState = session.getState(CommonState.class);
        VersioningState vState = session.getState(VersioningState.class);
        boolean ignoreSuffix = cState.isStrictIgnoreSuffix();
        Set<String> oldValueOptions = PropertiesUtils.buildOldValueSet(vState, oldValue);
        boolean result = false;
        if (vState.getAllSuffixes().isEmpty()) {
            logger.warn("No version suffixes found ; unable to determine strict mapping");
        }
        block0: for (String origValue : oldValueOptions) {
            for (String suffix : vState.getAllSuffixes()) {
                String v = origValue;
                if (!vState.isPreserveSnapshot()) {
                    v = Version.removeSnapshot(v);
                }
                String osgiVersion = Version.getOsgiVersion(v);
                String newVersion = newValue;
                if (StringUtils.isNotEmpty(suffix)) {
                    if (ignoreSuffix && origValue.contains(suffix)) {
                        HashSet<String> s = new HashSet<String>();
                        s.add(origValue);
                        s.add(newValue);
                        String x = String.valueOf(Version.findHighestMatchingBuildNumber(v, s));
                        if (newValue.endsWith(x)) {
                            String oldValueCache = origValue;
                            v = origValue = origValue.substring(0, origValue.indexOf(suffix) - 1);
                            osgiVersion = Version.getOsgiVersion(v);
                            logger.debug("Updating version to {} and for oldValue {} with newValue {}", v, oldValueCache, newValue);
                        } else if (origValue.endsWith(x)) {
                            logger.warn("strictValueChecking with strictIgnoreSuffix found older value ({}) was newer ({}) ", (Object)origValue, (Object)newValue);
                        } else {
                            logger.warn("strictIgnoreSuffix set but unable to align from {} to {}", (Object)origValue, (Object)newValue);
                        }
                    }
                    if (!Version.hasQualifier(v)) {
                        v = Version.appendQualifierSuffix(v, suffix);
                        osgiVersion = Version.getOsgiVersion(v);
                        osgiVersion = osgiVersion.substring(0, osgiVersion.indexOf(suffix) - 1);
                    }
                    if (newValue.contains(suffix)) {
                        newVersion = newValue.substring(0, newValue.indexOf(suffix) - 1);
                    }
                }
                boolean success = origValue.equals(newVersion) || osgiVersion.equals(newVersion);
                logger.debug("When validating original {} / new value {} comparing {} to {} and OSGi variant {} to {} (utilising suffix {}) is {}", origValue, newValue, origValue, newVersion, osgiVersion, newVersion, suffix, success ? "allowed" : "not allowed");
                if (!success) continue;
                result = true;
                break block0;
            }
        }
        return result;
    }

    public static boolean cacheProperty(Project project, CommonState state, Map<Project, Map<String, PropertyMapper>> versionPropertyUpdateMap, String oldVersion, String newVersion, Object originalType, boolean force) throws ManipulationException {
        Map projectProps = versionPropertyUpdateMap.computeIfAbsent(project, k -> new HashMap());
        boolean result = false;
        if (StringUtils.contains(oldVersion, "${")) {
            int endIndex = oldVersion.indexOf(125);
            String oldProperty = oldVersion.substring(2, endIndex);
            if (!StringUtils.startsWith(oldVersion, "${") || !StringUtils.endsWith(oldVersion, "}") || StringUtils.countMatches(oldVersion, "${") > 1) {
                logger.debug("For {} ; original version contains hardcoded value or multiple embedded properties. Not caching value ( {} -> {} )", originalType, oldVersion, newVersion);
            } else if ("project.version".equals(oldProperty)) {
                logger.debug("For {} ; original version was a property mapping. Not caching value as property is built-in ( {} -> {} )", originalType, oldProperty, newVersion);
            } else {
                ProjectRef originalReference;
                logger.debug("For {} ; original version was a property mapping; caching new value for update {} -> {} for project {}", originalType, oldProperty, newVersion, project);
                String oldVersionProp = oldVersion.substring(2, oldVersion.length() - 1);
                PropertyMapper container = projectProps.computeIfAbsent(oldVersionProp, k -> new PropertyMapper());
                String existingPropertyMapping = container.getNewVersion();
                if (originalType instanceof ProjectVersionRef) {
                    originalReference = ((ProjectVersionRef)originalType).asProjectRef();
                } else if (originalType instanceof Plugin) {
                    originalReference = new SimpleProjectRef(((Plugin)originalType).getGroupId(), ((Plugin)originalType).getArtifactId());
                } else {
                    throw new ManipulationException("Unknown type for {}", originalType == null ? null : originalType.getClass());
                }
                if (existingPropertyMapping != null && !existingPropertyMapping.equals(newVersion)) {
                    if (force) {
                        logger.debug("Override property replacement of {} with force version override {}", (Object)existingPropertyMapping, (Object)newVersion);
                    } else {
                        if (state.isPropertyClashFails()) {
                            logger.error("Replacing property '{}' with a new version but the existing version does not match. Old value is {} and new is {}. Context was replacing {} and clashed with {}", oldVersionProp, existingPropertyMapping, newVersion, originalType, container.getDependencies());
                            throw new ManipulationException("Property replacement clash - updating property '{}' to both {} and {}", oldVersionProp, existingPropertyMapping, newVersion);
                        }
                        logger.warn("Replacing property '{}' with a new version would clash with existing version which does not match. Old value is {} and new is {}. Purging update of existing property. Context was replacing {} and clashed with {}", oldVersionProp, existingPropertyMapping, newVersion, originalType, container.getDependencies());
                        projectProps.remove(oldVersionProp);
                        return false;
                    }
                }
                container.getDependencies().add(originalReference);
                container.setOriginalVersion(PropertiesUtils.findProperty(project, oldVersionProp));
                container.setNewVersion(newVersion);
                logger.debug("Container is {}", (Object)container);
                result = true;
            }
        }
        return result;
    }

    private static String findProperty(Project project, String prop) {
        return project.getReverseInheritedList().stream().filter(p -> p.getModel().getProperties().containsKey(prop)).map(p -> p.getModel().getProperties().getProperty(prop)).findAny().orElse(null);
    }

    public static String extractPropertyName(String version) throws ManipulationException {
        int endIndex = version.indexOf(125);
        if (version.indexOf("${") != 0 || endIndex != version.length() - 1) {
            throw new ManipulationException("NYI : handling for versions ({}) with either multiple embedded properties or embedded property and hardcoded string is NYI. ", version);
        }
        return version.substring(2, endIndex);
    }

    public static void verifyPropertyMapping(CommonState cState, Project project, Map<Project, Map<String, PropertyMapper>> versionPropertyMap, ProjectVersionRef pvr, String version) throws ManipulationException {
        PropertyMapper currentProjectVersionMapper;
        Map<String, PropertyMapper> mapping = versionPropertyMap.get(project);
        if (mapping.containsKey(version) && !(currentProjectVersionMapper = mapping.get(version)).getDependencies().contains(pvr.asProjectRef())) {
            logger.debug("Scanning project {} with version {} and original value {}", project, version, currentProjectVersionMapper.getOriginalVersion());
            if (cState.getStrictDependencyPluginPropertyValidation() == 2) {
                for (Map.Entry<Project, Map<String, PropertyMapper>> entry : versionPropertyMap.entrySet()) {
                    Project p = entry.getKey();
                    Map<String, PropertyMapper> allProjectMapper = entry.getValue();
                    if (!allProjectMapper.containsKey(version) || currentProjectVersionMapper.getOriginalVersion().equals(allProjectMapper.get(version).getNewVersion()) || !currentProjectVersionMapper.getOriginalVersion().equals(allProjectMapper.get(version).getOriginalVersion())) continue;
                    logger.warn("Project {} had a property {} that failed to validate to new version {} and is reverted to {}", p, version, allProjectMapper.get(version).getNewVersion(), allProjectMapper.get(version).getOriginalVersion());
                    allProjectMapper.get(version).setNewVersion(currentProjectVersionMapper.getOriginalVersion());
                }
            } else {
                throw new ManipulationException("Dependency or Plugin {} within project {}} did not update property {} but it has been updated", pvr, project, version);
            }
        }
    }

    static Set<String> buildOldValueSet(VersioningState versioningState, String oldValue) {
        HashSet<String> result = new HashSet<String>();
        result.add(oldValue);
        if (versioningState.getAllSuffixes().size() > 1) {
            versioningState.getSuffixAlternatives().forEach(s -> {
                String suffixStripRegExp = "(.*)([.|-])(" + s + "-\\d+)";
                Pattern suffixStripPattern = Pattern.compile(suffixStripRegExp);
                Matcher suffixMatcher = suffixStripPattern.matcher(oldValue);
                if (suffixMatcher.matches() && !oldValue.contains(versioningState.getRebuildSuffix())) {
                    result.add(suffixMatcher.group(1) + suffixMatcher.group(2) + versioningState.getRebuildSuffix() + "-0");
                }
            });
        }
        logger.debug("Generated original value set for matching {}", (Object)result);
        return result;
    }

    public static void handleConfigPrecedence(Properties userProperties, Properties config) {
        String value = userProperties.getProperty("allowConfigFilePrecedence");
        if (StringUtils.isNotEmpty(value) && "true".equalsIgnoreCase(value)) {
            userProperties.putAll((Map<?, ?>)config);
        } else {
            for (String key : config.stringPropertyNames()) {
                if (userProperties.containsKey(key)) continue;
                userProperties.setProperty(key, config.getProperty(key));
            }
        }
    }

    public static enum PropertyUpdate {
        FOUND,
        NOTFOUND,
        IGNORE;

    }
}

