/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLState
implements State {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String XML_PROPERTY = "xmlUpdate";
    private final List<XMLOperation> xmlOperations = new ArrayList<XMLOperation>();

    public XMLState(Properties userProps) throws ManipulationException {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) throws ManipulationException {
        String property = userProps.getProperty(XML_PROPERTY);
        if (StringUtils.isNotEmpty(property)) {
            String[] ops = property.split("(?<!\\\\),");
            for (int i = 0; i < ops.length; ++i) {
                ops[i] = ops[i].replaceAll("\\\\,", ",");
            }
            for (String operation : ops) {
                String[] components = operation.split("(?<!\\\\):", 3);
                for (int i = 0; i < components.length; ++i) {
                    components[i] = components[i].replaceAll("\\\\:", ":");
                }
                if (components.length != 3) {
                    throw new ManipulationException("Unable to parse command {} from property {}", operation, property);
                }
                this.logger.debug("Adding XMLOperation with file {}, xpath {} and update {}", components[0], components[1], components[2]);
                this.xmlOperations.add(new XMLOperation(components[0], components[1], components[2]));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return !this.xmlOperations.isEmpty();
    }

    public List<XMLOperation> getXMLOperations() {
        return this.xmlOperations;
    }

    public static final class XMLOperation {
        private final String file;
        private final String xpath;
        private final String update;

        public XMLOperation(String file, String xpath, String update) {
            this.file = file;
            this.xpath = xpath;
            this.update = update;
        }

        public String getFile() {
            return this.file;
        }

        public String getXPath() {
            return this.xpath;
        }

        public String getUpdate() {
            return this.update;
        }

        public String toString() {
            return "File " + this.file + " xpath '" + this.xpath + "' update " + this.update;
        }
    }
}

