/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Properties;
import org.commonjava.maven.ext.core.state.State;

public class PluginInjectingState
implements State {
    private static final String PROJECT_SOURCES_SKIP_PROPERTY = "projectSrcSkip";
    private static final String BMMP_SKIP_PROPERTY = "projectMetaSkip";
    private static final String PROJECT_SOURCES_PLUGIN_VERSION_PROPERTY = "projectSrcVersion";
    private static final String DEFAULT_PROJECT_SOURCES_PLUGIN_VERSION = "1.0";
    private static final String BMMP_VERSION_PROPERTY = "projectMetaVersion";
    private static final String DEFAULT_BMMP_VERSION = "1.7.0";
    private boolean projectsourcesEnabled;
    private boolean metadataEnabled;
    private String projectSrcPluginVersion;
    private String bmmpVersion;

    public PluginInjectingState(Properties userProperties) {
        this.initialise(userProperties);
    }

    @Override
    public void initialise(Properties userProperties) {
        this.projectsourcesEnabled = !Boolean.parseBoolean(userProperties.getProperty(PROJECT_SOURCES_SKIP_PROPERTY, "true"));
        this.metadataEnabled = !Boolean.parseBoolean(userProperties.getProperty(BMMP_SKIP_PROPERTY, "true"));
        this.projectSrcPluginVersion = userProperties.getProperty(PROJECT_SOURCES_PLUGIN_VERSION_PROPERTY, DEFAULT_PROJECT_SOURCES_PLUGIN_VERSION);
        this.bmmpVersion = userProperties.getProperty(BMMP_VERSION_PROPERTY, DEFAULT_BMMP_VERSION);
    }

    @Override
    public boolean isEnabled() {
        return this.isBuildMetadataPluginEnabled() || this.isProjectSourcesPluginEnabled();
    }

    public boolean isProjectSourcesPluginEnabled() {
        return this.projectsourcesEnabled;
    }

    public boolean isBuildMetadataPluginEnabled() {
        return this.metadataEnabled;
    }

    public String getProjectSourcesPluginVersion() {
        return this.projectSrcPluginVersion;
    }

    public String getBuildMetadataPluginVersion() {
        return this.bmmpVersion;
    }

    static {
        State.activeByDefault.add(PluginInjectingState.class);
    }
}

