/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Properties;
import org.apache.maven.model.Parent;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.core.state.State;

public class ParentInjectionState
implements State {
    private static final String PARENT_INJECTION_PROPERTY = "parentInjection";
    private Parent parent = new Parent();

    public ParentInjectionState(Properties userProps) {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) {
        String gav = userProps.getProperty(PARENT_INJECTION_PROPERTY);
        if (gav != null) {
            ProjectVersionRef ref = SimpleProjectVersionRef.parse(gav);
            this.parent = new Parent();
            this.parent.setGroupId(ref.getGroupId());
            this.parent.setArtifactId(ref.getArtifactId());
            this.parent.setVersion(ref.getVersionString());
            this.parent.setRelativePath("");
        } else {
            this.parent = null;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.parent != null;
    }

    public Parent getParentInjection() {
        return this.parent;
    }
}

