/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.core.util.PropertiesUtils;

public class DependencyState
implements State {
    @Deprecated
    public static final String DEPENDENCY_EXCLUSION_PREFIX = "dependencyExclusion.";
    public static final String DEPENDENCY_SOURCE = "dependencySource";
    public static final String DEPENDENCY_OVERRIDE_PREFIX = "dependencyOverride.";
    public static final String DEPENDENCY_MANAGEMENT_POM_PROPERTY = "dependencyManagement";
    public static final String EXTRA_BOM_PREFIX = "dependencyManagement.";
    private List<ProjectVersionRef> remoteBOMdepMgmt;
    private Map<String, ProjectVersionRef> extraBOMs;
    private Map<String, Map<ProjectRef, String>> extraBOMDepMgmts;
    private Map<String, String> dependencyOverrides;
    private Map<ArtifactRef, String> remoteRESTdepMgmt;
    private DependencyPrecedence precedence;

    public DependencyState(Properties userProps) throws ManipulationException {
        this.initialise(userProps);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialise(Properties userProps) throws ManipulationException {
        void var3_7;
        this.remoteBOMdepMgmt = IdUtils.parseGAVs(userProps.getProperty(DEPENDENCY_MANAGEMENT_POM_PROPERTY));
        this.extraBOMDepMgmts = new HashMap<String, Map<ProjectRef, String>>();
        this.extraBOMs = new HashMap<String, ProjectVersionRef>();
        for (Map.Entry<String, String> entry : PropertiesUtils.getPropertiesByPrefix(userProps, EXTRA_BOM_PREFIX).entrySet()) {
            this.extraBOMs.put(entry.getKey(), SimpleProjectVersionRef.parse(entry.getValue()));
        }
        this.dependencyOverrides = PropertiesUtils.getPropertiesByPrefix(userProps, DEPENDENCY_EXCLUSION_PREFIX);
        Map<String, String> oP = PropertiesUtils.getPropertiesByPrefix(userProps, DEPENDENCY_OVERRIDE_PREFIX);
        for (Map.Entry<String, String> entry : oP.entrySet()) {
            String s = entry.getKey();
            if (this.dependencyOverrides.put(s, entry.getValue()) == null) continue;
            throw new ManipulationException("Property clash between dependencyOverride and dependencyExclusion for {}", s);
        }
        String string = userProps.getProperty(DEPENDENCY_SOURCE, DependencyPrecedence.BOM.toString()).toUpperCase();
        if (StringUtils.isEmpty(string)) {
            String string2 = "NONE";
        }
        switch (DependencyPrecedence.valueOf((String)var3_7)) {
            case REST: {
                this.precedence = DependencyPrecedence.REST;
                break;
            }
            case BOM: {
                this.precedence = DependencyPrecedence.BOM;
                break;
            }
            case RESTBOM: {
                this.precedence = DependencyPrecedence.RESTBOM;
                break;
            }
            case BOMREST: {
                this.precedence = DependencyPrecedence.BOMREST;
                break;
            }
            case NONE: {
                this.precedence = DependencyPrecedence.NONE;
                break;
            }
            default: {
                throw new ManipulationException("Unknown value {} for {}", userProps.getProperty(DEPENDENCY_SOURCE), DEPENDENCY_SOURCE);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.precedence != DependencyPrecedence.NONE && this.remoteBOMdepMgmt != null && !this.remoteBOMdepMgmt.isEmpty() || this.remoteRESTdepMgmt != null && !this.remoteRESTdepMgmt.isEmpty() || !this.dependencyOverrides.isEmpty();
    }

    public List<ProjectVersionRef> getRemoteBOMDepMgmt() {
        return this.remoteBOMdepMgmt;
    }

    public Map<String, ProjectVersionRef> getExtraBOMs() {
        return this.extraBOMs;
    }

    public Map<String, Map<ProjectRef, String>> getExtraBOMDepMgmts() {
        return this.extraBOMDepMgmts;
    }

    public DependencyPrecedence getPrecedence() {
        return this.precedence;
    }

    public void setRemoteRESTOverrides(Map<ArtifactRef, String> overrides) {
        this.remoteRESTdepMgmt = overrides;
    }

    public Map<ArtifactRef, String> getRemoteRESTOverrides() {
        if (this.remoteRESTdepMgmt == null) {
            this.remoteRESTdepMgmt = new HashMap<ArtifactRef, String>();
        }
        return this.remoteRESTdepMgmt;
    }

    public Map<String, String> getDependencyOverrides() {
        return this.dependencyOverrides;
    }

    public static enum DependencyPrecedence {
        REST,
        BOM,
        RESTBOM,
        BOMREST,
        NONE;


        public String toString() {
            switch (this) {
                case BOMREST: {
                    return "BOM first, then REST";
                }
                case RESTBOM: {
                    return "REST first, then BOM";
                }
            }
            return this.name();
        }
    }
}

