/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleTypeAndClassifier;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.model.SimpleScopedArtifactRef;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.impl.Version;
import org.commonjava.maven.ext.core.impl.VersionCalculator;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.PluginState;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="rest-manipulator")
@Singleton
public class RESTCollector
implements Manipulator {
    private static final Logger logger = LoggerFactory.getLogger(RESTCollector.class);
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new RESTState(session));
    }

    private void collect(List<Project> projects) throws ManipulationException {
        RESTState state = this.session.getState(RESTState.class);
        VersioningState vs = this.session.getState(VersioningState.class);
        DependencyState ds = this.session.getState(DependencyState.class);
        PluginState ps = this.session.getState(PluginState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return;
        }
        ArrayList<ProjectVersionRef> restLookupProjectVersionParamList = new ArrayList<ProjectVersionRef>();
        String override = vs.getOverride();
        for (Project project : projects) {
            if (StringUtils.isEmpty(override)) {
                restLookupProjectVersionParamList.add(new SimpleProjectVersionRef(project.getKey().asProjectRef(), RESTCollector.handlePotentialSnapshotVersion(vs, Version.getOsgiVersion(VersionCalculator.handleAlternate(vs, project.getVersion())))));
                continue;
            }
            if (!project.isExecutionRoot()) continue;
            Project p = projects.get(0);
            restLookupProjectVersionParamList.add(new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId(), override));
        }
        ArrayList<ProjectVersionRef> restLookupVersionsParamList = new ArrayList<ProjectVersionRef>();
        Set<ArtifactRef> localDeps = RESTCollector.establishAllDependencies(this.session, projects, null);
        for (ArtifactRef p : localDeps) {
            restLookupVersionsParamList.add(p.asProjectVersionRef());
        }
        logger.debug("Passing {} GAVs into the REST client api {}", (Object)restLookupVersionsParamList.size(), (Object)restLookupVersionsParamList);
        Map<ProjectVersionRef, String> vRestResult = state.getVersionTranslator().lookupVersions(restLookupVersionsParamList);
        logger.info("REST Client returned: {}", (Object)vRestResult);
        logger.debug("Passing {} Project GAVs into the REST client api {}", (Object)restLookupProjectVersionParamList.size(), (Object)restLookupProjectVersionParamList);
        Map<ProjectVersionRef, String> pvResultResult = state.getVersionTranslator().lookupProjectVersions(restLookupProjectVersionParamList);
        logger.info("REST Client returned for project versions: {}", (Object)pvResultResult);
        HashMap<ProjectRef, Set<String>> versionStates = new HashMap<ProjectRef, Set<String>>();
        pvResultResult.forEach((key, value) -> {
            Set versions = versionStates.computeIfAbsent(key.asProjectRef(), k -> new HashSet());
            versions.add(value);
        });
        vs.setRESTMetadata(versionStates);
        HashMap<ArtifactRef, String> overrides = new HashMap<ArtifactRef, String>();
        for (ArtifactRef a : localDeps) {
            ProjectVersionRef pvr = a.asProjectVersionRef();
            if (vRestResult.containsKey(pvr)) {
                overrides.put(a, vRestResult.get(pvr));
            }
            if (!pvResultResult.containsKey(pvr)) continue;
            overrides.put(a, pvResultResult.get(pvr));
        }
        logger.debug("Setting REST Overrides {}", (Object)overrides);
        ds.setRemoteRESTOverrides(overrides);
        ps.setRemoteRESTOverrides(overrides);
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        this.collect(projects);
        return Collections.emptySet();
    }

    @Override
    public int getExecutionIndex() {
        return 10;
    }

    public static Set<ArtifactRef> establishAllDependencies(ManipulationSession session, List<Project> projects, Set<String> activeProfiles) throws ManipulationException {
        List<Profile> profiles;
        VersioningState vs = session.getState(VersioningState.class);
        HashSet<ArtifactRef> localDeps = new HashSet<ArtifactRef>();
        HashSet<String> activeModules = new HashSet<String>();
        boolean scanAll = false;
        if (activeProfiles != null && !activeProfiles.isEmpty()) {
            for (Project project : projects) {
                if (!project.isInheritanceRoot()) continue;
                activeModules.addAll(project.getModel().getModules());
                profiles = project.getModel().getProfiles();
                if (profiles == null) continue;
                for (Profile p : profiles) {
                    if (!activeProfiles.contains(p.getId())) continue;
                    logger.debug("Adding modules for profile {}", (Object)p.getId());
                    activeModules.addAll(p.getModules());
                }
            }
            logger.debug("Found {} active modules with {} active profiles.", (Object)activeModules, (Object)activeProfiles);
        } else {
            scanAll = true;
        }
        for (Project project : projects) {
            if (!project.isInheritanceRoot() && !scanAll && !activeModules.contains(project.getPom().getParentFile().getName())) continue;
            if (project.getModelParent() != null) {
                SimpleProjectVersionRef parent = new SimpleProjectVersionRef(project.getModelParent().getGroupId(), project.getModelParent().getArtifactId(), RESTCollector.handlePotentialSnapshotVersion(vs, project.getModelParent().getVersion()));
                localDeps.add(new SimpleScopedArtifactRef((ProjectVersionRef)parent, new SimpleTypeAndClassifier("pom", null), null));
            }
            RESTCollector.recordDependencies(session, localDeps, project.getResolvedManagedDependencies(session));
            RESTCollector.recordDependencies(session, localDeps, project.getResolvedDependencies(session));
            RESTCollector.recordPlugins(session, localDeps, project.getResolvedManagedPlugins(session));
            RESTCollector.recordPlugins(session, localDeps, project.getResolvedPlugins(session));
            profiles = project.getModel().getProfiles();
            if (profiles == null) continue;
            for (Profile p : profiles) {
                if (!scanAll && !activeProfiles.contains(p.getId())) continue;
                RESTCollector.recordDependencies(session, localDeps, project.getResolvedProfileManagedDependencies(session).getOrDefault(p, Collections.emptyMap()));
                RESTCollector.recordDependencies(session, localDeps, project.getResolvedProfileDependencies(session).getOrDefault(p, Collections.emptyMap()));
                RESTCollector.recordPlugins(session, localDeps, project.getResolvedProfileManagedPlugins(session).getOrDefault(p, Collections.emptyMap()));
                RESTCollector.recordPlugins(session, localDeps, project.getResolvedProfilePlugins(session).getOrDefault(p, Collections.emptyMap()));
            }
        }
        return localDeps;
    }

    private static void recordPlugins(ManipulationSession session, Set<ArtifactRef> deps, Map<ProjectVersionRef, Plugin> plugins) {
        VersioningState vs = session.getState(VersioningState.class);
        for (ProjectVersionRef pvr : plugins.keySet()) {
            deps.add(new SimpleScopedArtifactRef((ProjectVersionRef)new SimpleProjectVersionRef(pvr.asProjectRef(), RESTCollector.handlePotentialSnapshotVersion(vs, pvr.getVersionString())), new SimpleTypeAndClassifier("maven-plugin", null), null));
        }
    }

    private static void recordDependencies(ManipulationSession session, Set<ArtifactRef> deps, Map<ArtifactRef, Dependency> dependencies) {
        VersioningState vs = session.getState(VersioningState.class);
        RESTState state = session.getState(RESTState.class);
        for (Map.Entry<ArtifactRef, Dependency> entry : dependencies.entrySet()) {
            ArtifactRef pvr = entry.getKey();
            Dependency d = entry.getValue();
            SimpleScopedArtifactRef sa = new SimpleScopedArtifactRef((ProjectVersionRef)new SimpleProjectVersionRef(pvr.asProjectRef(), RESTCollector.handlePotentialSnapshotVersion(vs, pvr.getVersionString())), new SimpleTypeAndClassifier(d.getType(), d.getClassifier()), d.getScope());
            boolean validate = true;
            if (sa.getVersionString().contains("$")) {
                validate = false;
            } else if (state != null && !state.isRestSuffixAlign() && (sa.getVersionString().contains(vs.getRebuildSuffix()) || vs.getSuffixAlternatives().stream().anyMatch(s -> sa.getVersionString().contains((CharSequence)s)))) {
                validate = false;
            }
            if (!validate) continue;
            deps.add(sa);
        }
    }

    private static String handlePotentialSnapshotVersion(VersioningState vs, String version) {
        if (vs != null && !vs.isPreserveSnapshot()) {
            return Version.removeSnapshot(version);
        }
        return version;
    }
}

