/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.PropertyState;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="property-manipulator")
@Singleton
public class PropertyManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ModelIO effectiveModelBuilder;
    private ManipulationSession session;

    @Inject
    public PropertyManipulator(ModelIO effectiveModelBuilder) {
        this.effectiveModelBuilder = effectiveModelBuilder;
    }

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new PropertyState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        PropertyState state = this.session.getState(PropertyState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        Properties overrides = this.loadRemotePOMProperties(state.getRemotePropertyMgmt());
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            if (overrides.isEmpty()) continue;
            if (project.isInheritanceRoot()) {
                this.logger.info("Applying property changes to: {}:{} with {}", project.getGroupId(), project.getArtifactId(), overrides);
                project.getModel().getProperties().putAll((Map<?, ?>)overrides);
                changed.add(project);
                continue;
            }
            HashSet<Object> keyClone = new HashSet<Object>(project.getModel().getProperties().keySet());
            keyClone.retainAll(overrides.keySet());
            if (keyClone.isEmpty()) continue;
            for (String string : keyClone) {
                this.logger.info("Overwriting property ({} in: {}:{} with value {}", string, project.getGroupId(), project.getArtifactId(), overrides.get(string));
                project.getModel().getProperties().put(string, overrides.get(string));
                changed.add(project);
            }
        }
        return changed;
    }

    private Properties loadRemotePOMProperties(List<ProjectVersionRef> remoteMgmt) throws ManipulationException {
        Properties overrides = new Properties();
        if (remoteMgmt == null || remoteMgmt.isEmpty()) {
            return overrides;
        }
        ListIterator<ProjectVersionRef> listIterator = remoteMgmt.listIterator(remoteMgmt.size());
        while (listIterator.hasPrevious()) {
            ProjectVersionRef ref = listIterator.previous();
            overrides.putAll((Map<?, ?>)this.effectiveModelBuilder.getRemotePropertyMappingOverrides(ref));
        }
        return overrides;
    }

    @Override
    public int getExecutionIndex() {
        return 30;
    }
}

