/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.ProjectVersionEnforcingState;
import org.commonjava.maven.ext.core.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="enforce-project-version")
@Singleton
public class ProjectVersionEnforcingManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new ProjectVersionEnforcingState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) {
        ProjectVersionEnforcingState state = this.session.getState(ProjectVersionEnforcingState.class);
        if (!(this.session.isEnabled() && this.session.anyStateEnabled(State.activeByDefault) && state != null && state.isEnabled())) {
            this.logger.debug("Project version enforcement is disabled.");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            Model model = project.getModel();
            model.getProperties().stringPropertyNames().stream().filter(k -> model.getProperties().getProperty((String)k).equals("${project.version}")).forEach(k -> {
                this.logger.debug("Replacing project.version within properties for project {} with key {}", (Object)project, k);
                model.getProperties().setProperty((String)k, project.getVersion());
                changed.add(project);
            });
            if (!model.getPackaging().equals("pom")) continue;
            this.enforceDependencyProjectVersion(project, model.getDependencies(), changed);
            if (model.getDependencyManagement() != null) {
                this.enforceDependencyProjectVersion(project, model.getDependencyManagement().getDependencies(), changed);
            }
            if (model.getBuild() != null) {
                this.enforcePluginProjectVersion(project, model.getBuild().getPlugins(), changed);
                if (model.getBuild().getPluginManagement() != null) {
                    this.enforcePluginProjectVersion(project, model.getBuild().getPluginManagement().getPlugins(), changed);
                }
            }
            List<Profile> profiles = ProfileUtils.getProfiles(this.session, model);
            for (Profile profile : profiles) {
                this.enforceDependencyProjectVersion(project, profile.getDependencies(), changed);
                if (profile.getDependencyManagement() != null) {
                    this.enforceDependencyProjectVersion(project, profile.getDependencyManagement().getDependencies(), changed);
                }
                if (profile.getBuild() == null) continue;
                this.enforcePluginProjectVersion(project, profile.getBuild().getPlugins(), changed);
                if (profile.getBuild().getPluginManagement() == null) continue;
                this.enforcePluginProjectVersion(project, profile.getBuild().getPluginManagement().getPlugins(), changed);
            }
        }
        if (!changed.isEmpty()) {
            this.logger.warn("Using ${project.version} in pom files may lead to unexpected errors with inheritance.");
        }
        return changed;
    }

    private void enforceDependencyProjectVersion(Project project, List<Dependency> dependencies, Set<Project> changed) {
        String newVersion = project.getVersion();
        dependencies.stream().filter(d -> "${project.version}".equals(d.getVersion())).forEach(d -> {
            this.logger.debug("Replacing project.version within {} for project {} with {}", d, project, newVersion);
            d.setVersion(newVersion);
            changed.add(project);
        });
    }

    private void enforcePluginProjectVersion(Project project, List<Plugin> plugins, Set<Project> changed) {
        String newVersion = project.getVersion();
        plugins.stream().filter(d -> "${project.version}".equals(d.getVersion())).forEach(d -> {
            this.logger.debug("Replacing project.version within {} for project {} with {}", d, project, newVersion);
            d.setVersion(newVersion);
            changed.add(project);
        });
    }

    @Override
    public int getExecutionIndex() {
        return 70;
    }
}

