/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.InvocationStage;
import org.commonjava.maven.ext.core.impl.BaseGroovyManipulator;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.GroovyState;
import org.commonjava.maven.ext.io.FileIO;
import org.commonjava.maven.ext.io.ModelIO;
import org.commonjava.maven.ext.io.PomIO;

@Named(value="groovy-injection-first")
@Singleton
public class InitialGroovyManipulator
extends BaseGroovyManipulator
implements Manipulator {
    @Inject
    public InitialGroovyManipulator(ModelIO modelIO, FileIO fileIO, PomIO pomIO) {
        super(modelIO, fileIO, pomIO);
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        GroovyState state = new GroovyState(session.getUserProperties());
        this.session = session;
        session.setState(state);
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        GroovyState state = this.session.getState(GroovyState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        List<File> groovyScripts = this.parseGroovyScripts(state.getGroovyScripts());
        HashSet<Project> changed = new HashSet<Project>(groovyScripts.size());
        for (File groovyScript : groovyScripts) {
            Project project = projects.stream().filter(Project::isExecutionRoot).findFirst().orElseThrow(() -> new ManipulationException("Unable to find execution root", new Object[0]));
            this.applyGroovyScript(projects, project, groovyScript);
            changed.add(project);
        }
        return changed;
    }

    @Override
    public int getExecutionIndex() {
        return InvocationStage.FIRST.getStageValue();
    }
}

