/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.groovy;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.BaseScriptUtils;
import org.commonjava.maven.ext.core.groovy.InvocationStage;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.io.FileIO;
import org.commonjava.maven.ext.io.ModelIO;
import org.commonjava.maven.ext.io.PomIO;
import org.commonjava.maven.ext.io.rest.Translator;

public abstract class BaseScript
extends BaseScriptUtils {
    private List<Project> projects;
    private Project project;
    private ProjectVersionRef gav;
    private File basedir;
    private Properties userProperties;
    private MavenSessionHandler session;
    private InvocationStage stage;
    private ModelIO modelIO;
    private FileIO fileIO;
    private PomIO pomIO;

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public List<Project> getProjects() {
        return this.projects;
    }

    @Override
    public ProjectVersionRef getGAV() {
        return this.gav;
    }

    @Override
    public File getBaseDir() {
        return this.basedir;
    }

    @Override
    public Properties getUserProperties() {
        return this.userProperties;
    }

    @Override
    public MavenSessionHandler getSession() {
        return this.session;
    }

    @Override
    public InvocationStage getInvocationStage() {
        return this.stage;
    }

    @Override
    public Translator getRESTAPI() throws ManipulationException {
        this.validateSession();
        return ((ManipulationSession)this.getSession()).getState(RESTState.class).getVersionTranslator();
    }

    public void setValues(PomIO pomIO, FileIO fileIO, ModelIO modelIO, ManipulationSession session, List<Project> projects, Project project, InvocationStage stage) throws ManipulationException {
        this.fileIO = fileIO;
        this.pomIO = pomIO;
        this.modelIO = modelIO;
        this.session = session;
        this.projects = projects;
        if (project != null) {
            this.gav = project.getKey();
        }
        this.project = project;
        if (session.getPom() != null) {
            this.basedir = session.getPom().getParentFile();
        }
        this.userProperties = session.getUserProperties();
        this.stage = stage;
        this.logger.info("Injecting values. Project is {} with basedir {} and properties {}", project, this.basedir, this.userProperties);
    }

    @Override
    public ModelIO getModelIO() {
        return this.modelIO;
    }

    @Override
    public FileIO getFileIO() {
        return this.fileIO;
    }

    @Override
    public PomIO getPomIO() {
        return this.pomIO;
    }
}

