/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.version;

import java.io.Serializable;
import org.commonjava.maven.atlas.ident.version.CompoundVersionSpec;
import org.commonjava.maven.atlas.ident.version.MultiVersionSpec;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.atlas.ident.version.VersionSpec;
import org.commonjava.maven.atlas.ident.version.VersionSpecComparisons;

public class RangeVersionSpec
implements VersionSpec,
Serializable,
MultiVersionSpec {
    private static final long serialVersionUID = 1L;
    private final SingleVersion lower;
    private final SingleVersion upper;
    private final boolean lowerInclusive;
    private final boolean upperInclusive;
    private final boolean snapshotAllowed;
    private final String rawExpression;

    public RangeVersionSpec(String rawExpression, SingleVersion lower, SingleVersion upper, boolean lowerInclusive, boolean upperInclusive) {
        this.rawExpression = rawExpression;
        if (lower == null && upper == null) {
            throw new IllegalArgumentException("You MUST supply at least a lower- or upper-bound version to have a valid range!");
        }
        this.lower = lower;
        this.upper = upper;
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
        this.snapshotAllowed = lower != null && lower.isSnapshot() || upper != null && upper.isSnapshot();
    }

    @Override
    public boolean isPinned() {
        return this.lowerInclusive && this.upperInclusive && this.lower != null && this.lower.equals(this.upper);
    }

    @Override
    public SingleVersion getPinnedVersion() {
        return this.isPinned() ? this.lower : null;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshotAllowed;
    }

    @Override
    public boolean isRelease() {
        return !this.isSnapshot();
    }

    @Override
    public String renderStandard() {
        return this.rawExpression == null ? String.format("%s%s,%s%s", this.lowerInclusive ? "[" : "(", this.lower == null ? "" : this.lower.renderStandard(), this.upperInclusive ? "]" : ")", this.upper == null ? "" : this.upper.renderStandard()) : this.rawExpression;
    }

    @Override
    public boolean contains(VersionSpec version) {
        if (version == null) {
            return false;
        }
        if (version instanceof SingleVersion) {
            return this.containsSingle((SingleVersion)version);
        }
        if (version instanceof RangeVersionSpec) {
            return this.containsRange((RangeVersionSpec)version);
        }
        for (VersionSpec spec : (CompoundVersionSpec)version) {
            if (this.contains(spec)) continue;
            return false;
        }
        return true;
    }

    private boolean containsRange(RangeVersionSpec version) {
        int comp;
        SingleVersion oLower = version.getLowerBound();
        SingleVersion oUpper = version.getUpperBound();
        if (this.lower != null) {
            if (oLower == null) {
                return false;
            }
            comp = VersionSpecComparisons.compareTo(this.lower, version);
            if (comp > 0 || comp == 0 && this.lowerInclusive && !version.isLowerBoundInclusive()) {
                return false;
            }
        }
        if (this.upper != null) {
            if (oUpper == null) {
                return false;
            }
            comp = VersionSpecComparisons.compareTo(this.upper, version);
            if (comp < 0 || comp == 0 && this.upperInclusive && !version.isUpperBoundInclusive()) {
                return false;
            }
        }
        return true;
    }

    private boolean containsSingle(SingleVersion version) {
        int comp;
        if (this.lower != null) {
            if (this.lowerInclusive && !this.lower.isRelease() && !version.isRelease()) {
                return true;
            }
            comp = VersionSpecComparisons.compareTo(this.lower, version);
            if (comp > 0 || comp == 0 && !this.lowerInclusive) {
                return false;
            }
        }
        if (this.upper != null) {
            if (this.upperInclusive && !this.upper.isRelease() && !version.isRelease()) {
                return true;
            }
            comp = VersionSpecComparisons.compareTo(this.upper, version);
            if (comp < 0 || comp == 0 && !this.upperInclusive) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(VersionSpec other) {
        return VersionSpecComparisons.compareTo(this, other);
    }

    public String toString() {
        return String.format("Range [lower=%s, lowerInclusive=%s, upper=%s, upperInclusive=%s, snapshots allowed? %s] (%s)", this.lower, this.lowerInclusive, this.upper, this.upperInclusive, this.snapshotAllowed, this.renderStandard());
    }

    public SingleVersion getLowerBound() {
        return this.lower;
    }

    public SingleVersion getUpperBound() {
        return this.upper;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerInclusive;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperInclusive;
    }

    @Override
    public boolean isConcrete() {
        return this.isPinned() && this.lower.isConcrete();
    }

    @Override
    public boolean isSingle() {
        return this.isPinned();
    }

    @Override
    public SingleVersion getConcreteVersion() {
        return this.isConcrete() ? this.lower.getConcreteVersion() : null;
    }

    @Override
    public SingleVersion getSingleVersion() {
        return this.isSingle() ? this.lower.getSingleVersion() : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lower == null ? 0 : this.lower.hashCode());
        result = 31 * result + (this.lowerInclusive ? 1231 : 1237);
        result = 31 * result + (this.snapshotAllowed ? 1231 : 1237);
        result = 31 * result + (this.upper == null ? 0 : this.upper.hashCode());
        result = 31 * result + (this.upperInclusive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeVersionSpec other = (RangeVersionSpec)obj;
        if (this.lower == null ? other.lower != null : !this.lower.equals(other.lower)) {
            return false;
        }
        if (this.lowerInclusive != other.lowerInclusive) {
            return false;
        }
        if (this.snapshotAllowed != other.snapshotAllowed) {
            return false;
        }
        if (this.upper == null ? other.upper != null : !this.upper.equals(other.upper)) {
            return false;
        }
        return this.upperInclusive == other.upperInclusive;
    }
}

