/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.jackson;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleVersionlessArtifactRef;
import org.commonjava.maven.atlas.ident.ref.VersionlessArtifactRef;

public final class SerializerIdentityUtils {
    private SerializerIdentityUtils() {
    }

    public static <T extends ProjectRef> T parse(String value, Class<T> type) throws IOException {
        Class realType = null;
        if (ArtifactRef.class.isAssignableFrom(type)) {
            realType = SimpleArtifactRef.class;
        } else if (VersionlessArtifactRef.class.isAssignableFrom(type)) {
            realType = SimpleVersionlessArtifactRef.class;
        } else if (ProjectVersionRef.class.isAssignableFrom(type)) {
            realType = SimpleProjectVersionRef.class;
        } else if (ProjectRef.class.isAssignableFrom(type)) {
            realType = SimpleProjectRef.class;
        } else {
            throw new IOException("Cannot find acceptable deserialization target class to parse: " + type.getSimpleName());
        }
        try {
            Method parseMethod = realType.getMethod("parse", String.class);
            return (T)((ProjectRef)type.cast(parseMethod.invoke(null, value)));
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Failed to lookup/invoke parse() method on " + type.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to lookup/invoke parse() method on " + type.getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Failed to lookup/invoke parse() method on " + type.getSimpleName(), e);
        }
    }
}

