/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import com.codahale.metrics.MetricRegistry;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.commonjava.cdi.util.weft.ContextSensitiveExecutorService;
import org.commonjava.cdi.util.weft.ExecutorConfig;
import org.commonjava.cdi.util.weft.NamedThreadFactory;
import org.commonjava.cdi.util.weft.SingleThreadedExecutorService;
import org.commonjava.cdi.util.weft.WeftManaged;
import org.commonjava.cdi.util.weft.WeftScheduledExecutor;
import org.commonjava.cdi.util.weft.config.WeftConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExecutorProvider {
    private final Map<String, ExecutorService> services = new ConcurrentHashMap<String, ExecutorService>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private WeftConfig config;
    private MetricRegistry metricRegistry;
    private SingleThreadedExecutorService singleThreaded = new SingleThreadedExecutorService();

    @PostConstruct
    public void init() {
        try {
            this.metricRegistry = (MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[0]).get();
        }
        catch (UnsatisfiedResolutionException e) {
            this.logger.info(e.getMessage());
        }
    }

    @PreDestroy
    public void shutdown() {
        for (Map.Entry<String, ExecutorService> entry : this.services.entrySet()) {
            ExecutorService service = entry.getValue();
            service.shutdown();
            try {
                List<Runnable> running;
                service.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                if (service.isTerminated() || (running = service.shutdownNow()).isEmpty()) continue;
                this.logger.warn("{} tasks remain for executor: {}", (Object)running.size(), (Object)entry.getKey());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @Produces
    @WeftManaged
    public ExecutorService getExecutorService(InjectionPoint ip) {
        return this.getExec(ip, false);
    }

    @Produces
    @WeftScheduledExecutor
    public ScheduledExecutorService getScheduledExecutorService(InjectionPoint ip) {
        return (ScheduledExecutorService)this.getExec(ip, true);
    }

    private ExecutorService getExec(InjectionPoint ip, boolean scheduled) {
        ExecutorConfig ec = ip.getAnnotated().getAnnotation(ExecutorConfig.class);
        Integer threadCount = 0;
        Integer priority = null;
        boolean daemon = true;
        String name = "weft-unannotated";
        if (ec != null) {
            threadCount = ec.threads();
            name = ec.named();
            priority = ec.priority();
            daemon = ec.daemon();
        }
        if (!this.config.isEnabled() || !this.config.isEnabled(name)) {
            return this.singleThreaded;
        }
        threadCount = this.config.getThreads(name, threadCount);
        priority = this.config.getPriority(name, priority);
        String key = name + ":" + (scheduled ? "scheduled" : "");
        ExecutorService service = this.services.get(key);
        if (service == null) {
            NamedThreadFactory fac = new NamedThreadFactory(name, daemon, priority);
            if (scheduled) {
                if (threadCount < 1) {
                    throw new RuntimeException(ip + " must specify a non-zero number for threads parameter in @ExecutorConfig.");
                }
                service = Executors.newScheduledThreadPool(threadCount, fac);
            } else {
                service = threadCount > 0 ? Executors.newFixedThreadPool(threadCount, fac) : Executors.newCachedThreadPool(fac);
            }
            if (this.metricRegistry != null && service instanceof ThreadPoolExecutor) {
                this.logger.info("Register thread pool metrics - {}", (Object)name);
                String prefix = MetricRegistry.name(this.config.getNodePrefix(), "weft.ThreadPoolExecutor", name);
                this.registerMetrics(this.metricRegistry, prefix, (ThreadPoolExecutor)service);
            }
            service = new ContextSensitiveExecutorService(service);
            this.services.put(key, service);
        }
        return service;
    }

    private void registerMetrics(MetricRegistry registry, String prefix, ThreadPoolExecutor executor) {
        registry.register(MetricRegistry.name(prefix, "corePoolSize"), () -> executor.getCorePoolSize());
        registry.register(MetricRegistry.name(prefix, "activeThreads"), () -> executor.getActiveCount());
        registry.register(MetricRegistry.name(prefix, "maxPoolSize"), () -> executor.getMaximumPoolSize());
        registry.register(MetricRegistry.name(prefix, "queueSize"), () -> executor.getQueue().size());
    }
}

