/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.policies;

import org.apache.maven.shared.release.policy.PolicyException;
import org.apache.maven.shared.release.policy.version.VersionPolicy;
import org.apache.maven.shared.release.policy.version.VersionPolicyRequest;
import org.apache.maven.shared.release.policy.version.VersionPolicyResult;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=VersionPolicy.class, hint="default")
public class DefaultVersionPolicy
implements VersionPolicy {
    @Override
    public VersionPolicyResult getReleaseVersion(VersionPolicyRequest request) throws PolicyException, VersionParseException {
        String releaseVersion = new DefaultVersionInfo(request.getVersion()).getReleaseVersionString();
        return new VersionPolicyResult().setVersion(releaseVersion);
    }

    @Override
    public VersionPolicyResult getDevelopmentVersion(VersionPolicyRequest request) throws PolicyException, VersionParseException {
        String developmentVersion = new DefaultVersionInfo(request.getVersion()).getNextVersion().getSnapshotVersionString();
        return new VersionPolicyResult().setVersion(developmentVersion);
    }
}

