/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.policy.PolicyException;
import org.apache.maven.shared.release.policy.naming.NamingPolicy;
import org.apache.maven.shared.release.policy.naming.NamingPolicyRequest;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.util.StringUtils;

public class InputVariablesPhase
extends AbstractReleasePhase {
    @Requirement
    private Prompter prompter;
    private boolean branchOperation;
    @Requirement
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    @Requirement
    private Map<String, NamingPolicy> namingPolicies;
    private String defaultNamingPolicy;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    boolean isBranchOperation() {
        return this.branchOperation;
    }

    protected ScmProvider getScmProvider(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment) throws ReleaseScmRepositoryException, ReleaseExecutionException {
        try {
            ScmRepository repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            return this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseDescriptor.getScmSourceUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        result = new ReleaseResult();
        project = ReleaseUtil.getRootProject(reactorProjects);
        tag = releaseDescriptor.getScmReleaseLabel();
        if (tag == null) {
            key = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            releaseVersion = releaseDescriptor.getProjectReleaseVersion(key);
            if (releaseVersion == null) {
                throw new ReleaseExecutionException("Project tag cannot be selected if version is not yet mapped");
            }
            scmTagNameFormat = releaseDescriptor.getScmTagNameFormat();
            if (releaseDescriptor.getProjectNamingPolicyId() != null) {
                try {
                    suggestedName = this.resolveSuggestedName(releaseDescriptor.getProjectNamingPolicyId(), releaseVersion, project);
                }
                catch (PolicyException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
            if (scmTagNameFormat != null) {
                interpolator = new StringSearchInterpolator("@{", "}");
                possiblePrefixes = Arrays.asList(new String[]{"project", "pom"});
                values = new Properties();
                values.setProperty("artifactId", project.getArtifactId());
                values.setProperty("groupId", project.getGroupId());
                values.setProperty("version", releaseVersion);
                interpolator.addValueSource(new PrefixedPropertiesValueSource(possiblePrefixes, values, true));
                recursionInterceptor = new PrefixAwareRecursionInterceptor(possiblePrefixes);
                try {
                    suggestedName = interpolator.interpolate(scmTagNameFormat, recursionInterceptor);
                }
                catch (InterpolationException e) {
                    throw new ReleaseExecutionException("Could not interpolate specified tag name format: " + scmTagNameFormat, e);
                }
            }
            try {
                suggestedName = this.resolveSuggestedName(this.defaultNamingPolicy, releaseVersion, project);
            }
            catch (PolicyException e) {
                throw new ReleaseExecutionException(e.getMessage(), e);
            }
            provider = null;
            try {
                provider = this.getScmProvider(releaseDescriptor, releaseEnvironment);
            }
            catch (ReleaseScmRepositoryException e) {
                throw new ReleaseExecutionException("No scm provider can be found for url: " + releaseDescriptor.getScmSourceUrl(), e);
            }
            suggestedName = provider.sanitizeTagName(suggestedName);
            if (releaseDescriptor.isInteractive()) {
                try {
                    if (this.branchOperation) {
                        tag = this.prompter.prompt("What is the branch name for \"" + project.getName() + "\"? (" + project.getGroupId() + ":" + project.getArtifactId() + ")");
                        if (!StringUtils.isEmpty(tag)) ** GOTO lbl60
                        throw new ReleaseExecutionException("No branch name was given.");
                    }
                    tag = this.prompter.prompt("What is the SCM release tag or label for \"" + project.getName() + "\"? (" + project.getGroupId() + ":" + project.getArtifactId() + ")", suggestedName);
                }
                catch (PrompterException e) {
                    throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
                }
            } else {
                if (suggestedName == null) {
                    if (this.isBranchOperation()) {
                        throw new ReleaseExecutionException("No branch name was given.");
                    }
                    throw new ReleaseExecutionException("No tag name was given.");
                }
                tag = suggestedName;
            }
lbl60:
            // 3 sources

            releaseDescriptor.setScmReleaseLabel(tag);
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        result.setResultCode(0);
        return result;
    }

    private String resolveSuggestedName(String policyId, String version, MavenProject project) throws PolicyException {
        if (policyId == null) {
            return null;
        }
        NamingPolicy policy = this.namingPolicies.get(policyId);
        if (policy == null) {
            throw new PolicyException("Policy '" + policyId + "' is unknown, available: " + this.namingPolicies.keySet());
        }
        NamingPolicyRequest request = new NamingPolicyRequest().setGroupId(project.getGroupId()).setArtifactId(project.getArtifactId()).setVersion(version);
        return policy.getName(request).getName();
    }
}

