/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.shared.release.config.ModelloReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseStageVersions;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ReleaseDescriptorXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public ReleaseDescriptorXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public ReleaseDescriptorXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public ModelloReleaseDescriptor read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict);
    }

    public ModelloReleaseDescriptor read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public ModelloReleaseDescriptor read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public ModelloReleaseDescriptor read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private ModelloReleaseDescriptor parseModelloReleaseDescriptor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ModelloReleaseDescriptor modelloReleaseDescriptor = new ModelloReleaseDescriptor();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                modelloReleaseDescriptor.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                modelloReleaseDescriptor.setDescription(this.interpolatedTrimmed(parser.nextText(), "description"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "ScmCommentPrefix", null, parsed)) {
                modelloReleaseDescriptor.setScmCommentPrefix(this.interpolatedTrimmed(parser.nextText(), "ScmCommentPrefix"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmReleaseCommitComment", null, parsed)) {
                modelloReleaseDescriptor.setScmReleaseCommitComment(this.interpolatedTrimmed(parser.nextText(), "scmReleaseCommitComment"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmDevelopmentCommitComment", null, parsed)) {
                modelloReleaseDescriptor.setScmDevelopmentCommitComment(this.interpolatedTrimmed(parser.nextText(), "scmDevelopmentCommitComment"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmBranchCommitComment", null, parsed)) {
                modelloReleaseDescriptor.setScmBranchCommitComment(this.interpolatedTrimmed(parser.nextText(), "scmBranchCommitComment"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmRollbackCommitComment", null, parsed)) {
                modelloReleaseDescriptor.setScmRollbackCommitComment(this.interpolatedTrimmed(parser.nextText(), "scmRollbackCommitComment"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmSourceUrl", null, parsed)) {
                modelloReleaseDescriptor.setScmSourceUrl(this.interpolatedTrimmed(parser.nextText(), "scmSourceUrl"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmTagBase", null, parsed)) {
                modelloReleaseDescriptor.setScmTagBase(this.interpolatedTrimmed(parser.nextText(), "scmTagBase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmBranchBase", null, parsed)) {
                modelloReleaseDescriptor.setScmBranchBase(this.interpolatedTrimmed(parser.nextText(), "scmBranchBase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmReleaseLabel", null, parsed)) {
                modelloReleaseDescriptor.setScmReleaseLabel(this.interpolatedTrimmed(parser.nextText(), "scmReleaseLabel"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmId", null, parsed)) {
                modelloReleaseDescriptor.setScmId(this.interpolatedTrimmed(parser.nextText(), "scmId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmUsername", null, parsed)) {
                modelloReleaseDescriptor.setScmUsername(this.interpolatedTrimmed(parser.nextText(), "scmUsername"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmPassword", null, parsed)) {
                modelloReleaseDescriptor.setScmPassword(this.interpolatedTrimmed(parser.nextText(), "scmPassword"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmPrivateKey", null, parsed)) {
                modelloReleaseDescriptor.setScmPrivateKey(this.interpolatedTrimmed(parser.nextText(), "scmPrivateKey"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmPrivateKeyPassPhrase", null, parsed)) {
                modelloReleaseDescriptor.setScmPrivateKeyPassPhrase(this.interpolatedTrimmed(parser.nextText(), "scmPrivateKeyPassPhrase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmUseEditMode", null, parsed)) {
                modelloReleaseDescriptor.setScmUseEditMode(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "scmUseEditMode"), "scmUseEditMode", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmRelativePathProjectDirectory", null, parsed)) {
                modelloReleaseDescriptor.setScmRelativePathProjectDirectory(this.interpolatedTrimmed(parser.nextText(), "scmRelativePathProjectDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updateDependencies", null, parsed)) {
                modelloReleaseDescriptor.setUpdateDependencies(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "updateDependencies"), "updateDependencies", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useReleaseProfile", null, parsed)) {
                modelloReleaseDescriptor.setUseReleaseProfile(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useReleaseProfile"), "useReleaseProfile", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "activateProfiles", null, parsed)) {
                ArrayList<String> activateProfiles = new ArrayList<String>();
                modelloReleaseDescriptor.setActivateProfiles(activateProfiles);
                while (parser.nextTag() == 2) {
                    if ("activateProfile".equals(parser.getName())) {
                        activateProfiles.add(this.interpolatedTrimmed(parser.nextText(), "activateProfiles"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "workingDirectory", null, parsed)) {
                modelloReleaseDescriptor.setWorkingDirectory(this.interpolatedTrimmed(parser.nextText(), "workingDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "checkoutDirectory", null, parsed)) {
                modelloReleaseDescriptor.setCheckoutDirectory(this.interpolatedTrimmed(parser.nextText(), "checkoutDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "completedPhase", null, parsed)) {
                modelloReleaseDescriptor.setCompletedPhase(this.interpolatedTrimmed(parser.nextText(), "completedPhase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "addSchema", null, parsed)) {
                modelloReleaseDescriptor.setAddSchema(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "addSchema"), "addSchema", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "generateReleasePoms", null, parsed)) {
                modelloReleaseDescriptor.setGenerateReleasePoms(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "generateReleasePoms"), "generateReleasePoms", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "autoVersionSubmodules", null, parsed)) {
                modelloReleaseDescriptor.setAutoVersionSubmodules(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "autoVersionSubmodules"), "autoVersionSubmodules", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "interactive", null, parsed)) {
                modelloReleaseDescriptor.setInteractive(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "interactive"), "interactive", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshotReleasePluginAllowed", null, parsed)) {
                modelloReleaseDescriptor.setSnapshotReleasePluginAllowed(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "snapshotReleasePluginAllowed"), "snapshotReleasePluginAllowed", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "additionalArguments", null, parsed)) {
                modelloReleaseDescriptor.setAdditionalArguments(this.interpolatedTrimmed(parser.nextText(), "additionalArguments"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pomFileName", null, parsed)) {
                modelloReleaseDescriptor.setPomFileName(this.interpolatedTrimmed(parser.nextText(), "pomFileName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "checkModificationExcludes", null, parsed)) {
                ArrayList<String> checkModificationExcludes = new ArrayList<String>();
                modelloReleaseDescriptor.setCheckModificationExcludes(checkModificationExcludes);
                while (parser.nextTag() == 2) {
                    if ("checkModificationExclude".equals(parser.getName())) {
                        checkModificationExcludes.add(this.interpolatedTrimmed(parser.nextText(), "checkModificationExcludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "preparationGoals", null, parsed)) {
                modelloReleaseDescriptor.setPreparationGoals(this.interpolatedTrimmed(parser.nextText(), "preparationGoals"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "completionGoals", null, parsed)) {
                modelloReleaseDescriptor.setCompletionGoals(this.interpolatedTrimmed(parser.nextText(), "completionGoals"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "performGoals", null, parsed)) {
                modelloReleaseDescriptor.setPerformGoals(this.interpolatedTrimmed(parser.nextText(), "performGoals"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "commitByProject", null, parsed)) {
                modelloReleaseDescriptor.setCommitByProject(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "commitByProject"), "commitByProject", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "branchCreation", null, parsed)) {
                modelloReleaseDescriptor.setBranchCreation(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "branchCreation"), "branchCreation", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updateBranchVersions", null, parsed)) {
                modelloReleaseDescriptor.setUpdateBranchVersions(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "updateBranchVersions"), "updateBranchVersions", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updateWorkingCopyVersions", null, parsed)) {
                modelloReleaseDescriptor.setUpdateWorkingCopyVersions(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "updateWorkingCopyVersions"), "updateWorkingCopyVersions", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updateVersionsToSnapshot", null, parsed)) {
                modelloReleaseDescriptor.setUpdateVersionsToSnapshot(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "updateVersionsToSnapshot"), "updateVersionsToSnapshot", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "suppressCommitBeforeTagOrBranch", null, parsed)) {
                modelloReleaseDescriptor.setSuppressCommitBeforeTagOrBranch(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "suppressCommitBeforeTagOrBranch"), "suppressCommitBeforeTagOrBranch", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "waitBeforeTagging", null, parsed)) {
                modelloReleaseDescriptor.setWaitBeforeTagging(this.getIntegerValue(this.interpolatedTrimmed(parser.nextText(), "waitBeforeTagging"), "waitBeforeTagging", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "allowTimestampedSnapshots", null, parsed)) {
                modelloReleaseDescriptor.setAllowTimestampedSnapshots(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "allowTimestampedSnapshots"), "allowTimestampedSnapshots", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "defaultReleaseVersion", null, parsed)) {
                modelloReleaseDescriptor.setDefaultReleaseVersion(this.interpolatedTrimmed(parser.nextText(), "defaultReleaseVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "defaultDevelopmentVersion", null, parsed)) {
                modelloReleaseDescriptor.setDefaultDevelopmentVersion(this.interpolatedTrimmed(parser.nextText(), "defaultDevelopmentVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectVersionPolicyId", null, parsed)) {
                modelloReleaseDescriptor.setProjectVersionPolicyId(this.interpolatedTrimmed(parser.nextText(), "projectVersionPolicyId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectNamingPolicyId", null, parsed)) {
                modelloReleaseDescriptor.setProjectNamingPolicyId(this.interpolatedTrimmed(parser.nextText(), "projectNamingPolicyId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "releaseStrategyId", null, parsed)) {
                modelloReleaseDescriptor.setReleaseStrategyId(this.interpolatedTrimmed(parser.nextText(), "releaseStrategyId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "remoteTagging", null, parsed)) {
                modelloReleaseDescriptor.setRemoteTagging(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "remoteTagging"), "remoteTagging", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmReleasedPomRevision", null, parsed)) {
                modelloReleaseDescriptor.setScmReleasedPomRevision(this.interpolatedTrimmed(parser.nextText(), "scmReleasedPomRevision"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pushChanges", null, parsed)) {
                modelloReleaseDescriptor.setPushChanges(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "pushChanges"), "pushChanges", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "localCheckout", null, parsed)) {
                modelloReleaseDescriptor.setLocalCheckout(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "localCheckout"), "localCheckout", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmTagNameFormat", null, parsed)) {
                modelloReleaseDescriptor.setScmTagNameFormat(this.interpolatedTrimmed(parser.nextText(), "scmTagNameFormat"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "workItem", null, parsed)) {
                modelloReleaseDescriptor.setWorkItem(this.interpolatedTrimmed(parser.nextText(), "workItem"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "autoResolveSnapshots", null, parsed)) {
                modelloReleaseDescriptor.setAutoResolveSnapshots(this.interpolatedTrimmed(parser.nextText(), "autoResolveSnapshots"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pinExternals", null, parsed)) {
                modelloReleaseDescriptor.setPinExternals(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "pinExternals"), "pinExternals", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scmSignTags", null, parsed)) {
                modelloReleaseDescriptor.setScmSignTags(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "scmSignTags"), "scmSignTags", parser, "false"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return modelloReleaseDescriptor;
    }

    private ReleaseStageVersions parseReleaseStageVersions(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ReleaseStageVersions releaseStageVersions = new ReleaseStageVersions();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "original", null, parsed)) {
                releaseStageVersions.setOriginal(this.interpolatedTrimmed(parser.nextText(), "original"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "release", null, parsed)) {
                releaseStageVersions.setRelease(this.interpolatedTrimmed(parser.nextText(), "release"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "development", null, parsed)) {
                releaseStageVersions.setDevelopment(this.interpolatedTrimmed(parser.nextText(), "development"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return releaseStageVersions;
    }

    private ModelloReleaseDescriptor read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ModelloReleaseDescriptor modelloReleaseDescriptor = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"modelloReleaseDescriptor".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'modelloReleaseDescriptor' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'modelloReleaseDescriptor'", parser, null);
                }
                modelloReleaseDescriptor = this.parseModelloReleaseDescriptor(parser, strict);
                modelloReleaseDescriptor.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return modelloReleaseDescriptor;
        }
        throw new XmlPullParserException("Expected root element 'modelloReleaseDescriptor' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

