/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.ErrorMessageType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ValidationMessage {
    private String type;
    private String code;
    private String path;
    private String schemaPath;
    private String[] arguments;
    private Map<String, Object> details;
    private String message;

    ValidationMessage() {
    }

    public String getCode() {
        return this.code;
    }

    void setCode(String code) {
        this.code = code;
    }

    public String getPath() {
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    void setDetails(Map<String, Object> details) {
        this.details = details;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationMessage that = (ValidationMessage)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.schemaPath != null ? !this.schemaPath.equals(that.schemaPath) : that.schemaPath != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (!Arrays.equals(this.arguments, that.arguments)) {
            return false;
        }
        return !(this.message == null ? that.message != null : !this.message.equals(that.message));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.schemaPath != null ? this.schemaPath.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static ValidationMessage of(String type, ErrorMessageType errorMessageType, String at, String schemaPath, String ... arguments) {
        Builder builder = new Builder();
        builder.code(errorMessageType.getErrorCode()).path(at).schemaPath(schemaPath).arguments(arguments).format(errorMessageType.getMessageFormat()).type(type).customMessage(errorMessageType.getCustomMessage());
        return builder.build();
    }

    public static ValidationMessage of(String type, ErrorMessageType errorMessageType, String at, String schemaPath, Map<String, Object> details) {
        Builder builder = new Builder();
        builder.code(errorMessageType.getErrorCode()).path(at).schemaPath(schemaPath).details(details).format(errorMessageType.getMessageFormat()).type(type);
        return builder.build();
    }

    public static class Builder {
        private String type;
        private String code;
        private String path;
        private String schemaPath;
        private String[] arguments;
        private Map<String, Object> details;
        private MessageFormat format;
        private String customMessage;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder schemaPath(String schemaPath) {
            this.schemaPath = schemaPath;
            return this;
        }

        public Builder arguments(String ... arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder details(Map<String, Object> details) {
            this.details = details;
            return this;
        }

        public Builder format(MessageFormat format) {
            this.format = format;
            return this;
        }

        public Builder customMessage(String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public ValidationMessage build() {
            ValidationMessage msg = new ValidationMessage();
            msg.setType(this.type);
            msg.setCode(this.code);
            msg.setPath(this.path);
            msg.setSchemaPath(this.schemaPath);
            msg.setArguments(this.arguments);
            msg.setDetails(this.details);
            if (this.format != null) {
                String[] objs = new String[(this.arguments == null ? 0 : this.arguments.length) + 1];
                objs[0] = this.path;
                if (this.arguments != null) {
                    for (int i = 1; i < objs.length; ++i) {
                        objs[i] = this.arguments[i - 1];
                    }
                }
                if (StringUtils.isNotBlank(this.customMessage)) {
                    msg.setMessage(this.customMessage);
                } else {
                    msg.setMessage(this.format.format(objs));
                }
            }
            return msg;
        }
    }
}

