/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.batch.BatchSubsystemDefinition;
import org.wildfly.extension.batch.job.repository.JobRepositoryFactory;
import org.wildfly.extension.batch.job.repository.JobRepositoryType;

class JobRepositoryDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "job-repository";
    public static final SimpleAttributeDefinition JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jndi-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).build();
    public static final JobRepositoryDefinition JDBC = new JobRepositoryDefinition(JobRepositoryType.JDBC.toString(), new AttributeDefinition[]{JNDI_NAME});

    private JobRepositoryDefinition(String name, AttributeDefinition ... attributes) {
        super(PathElement.pathElement((String)NAME, (String)name), (ResourceDescriptionResolver)BatchSubsystemDefinition.getResourceDescriptionResolver(NAME, name), (OperationStepHandler)new JobRepositoryAdd(attributes), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)JNDI_NAME, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{JNDI_NAME}));
    }

    private static class JobRepositoryAdd
    extends AbstractAddStepHandler {
        public JobRepositoryAdd(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            ModelNode jndiName = JNDI_NAME.resolveModelAttribute(context, model);
            if (jndiName.isDefined()) {
                JobRepositoryFactory.getInstance().setJndiName(jndiName.asString());
            }
        }
    }
}

