/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.deployment;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.repository.JobRepository;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.extension.batch.BatchServiceNames;
import org.wildfly.extension.batch._private.BatchLogger;
import org.wildfly.extension.batch.deployment.BatchDeploymentDescriptorParser;
import org.wildfly.extension.batch.deployment.JobXmlResolverService;
import org.wildfly.extension.batch.job.repository.JobRepositoryFactory;
import org.wildfly.jberet.services.BatchEnvironmentService;

public class BatchEnvironmentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.MODULE)) {
            JobXmlResolverService jobXmlResolverService;
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch environment.", deploymentUnit.getName());
            Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            JobRepository jobRepository = (JobRepository)deploymentUnit.getAttachment(BatchDeploymentDescriptorParser.ATTACHMENT_KEY);
            if (jobRepository == null) {
                DeploymentUnit parent = deploymentUnit.getParent();
                if (parent != null) {
                    jobRepository = (JobRepository)deploymentUnit.getAttachment(BatchDeploymentDescriptorParser.ATTACHMENT_KEY);
                }
                if (jobRepository == null) {
                    jobRepository = JobRepositoryFactory.getInstance().getJobRepository(moduleDescription);
                }
            }
            BatchEnvironmentService service = new BatchEnvironmentService((ClassLoader)moduleClassLoader, jobRepository);
            ServiceBuilder serviceBuilder = serviceTarget.addService(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit), (Service)service);
            serviceBuilder.addDependency(BatchServiceNames.BATCH_THREAD_POOL_NAME, ExecutorService.class, (Injector)service.getExecutorServiceInjector());
            serviceBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, (Injector)service.getTransactionManagerInjector());
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                BatchLogger.LOGGER.tracef("Adding BeanManager service dependency for deployment %s", deploymentUnit.getName());
                serviceBuilder.addDependency(BatchServiceNames.beanManagerServiceName(deploymentUnit), BeanManager.class, (Injector)service.getBeanManagerInjector());
            }
            VirtualFile root = ((ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT)).getRoot();
            VirtualFile jobsDir = null;
            jobsDir = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) ? root.getChild("WEB-INF/classes/META-INF/batch-jobs") : root.getChild("META-INF/batch-jobs");
            if (jobsDir != null && jobsDir.exists()) {
                try {
                    jobXmlResolverService = new JobXmlResolverService((ClassLoader)moduleClassLoader, jobsDir.getChildren((VirtualFileFilter)JobXmlFilter.INSTANCE));
                }
                catch (IOException e) {
                    throw BatchLogger.LOGGER.errorProcessingBatchJobsDir(e);
                }
            } else {
                jobXmlResolverService = new JobXmlResolverService();
            }
            serviceTarget.addService(BatchServiceNames.jobXmlResolverServiceName(deploymentUnit), (Service)jobXmlResolverService).install();
            serviceBuilder.addDependency(BatchServiceNames.jobXmlResolverServiceName(deploymentUnit), JobXmlResolver.class, (Injector)service.getJobXmlResolverInjector());
            serviceBuilder.install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class JobXmlFilter
    implements VirtualFileFilter {
        static final JobXmlFilter INSTANCE = new JobXmlFilter();

        private JobXmlFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return file.isFile() && file.getName().endsWith(".xml");
        }
    }
}

