/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.thread.pool;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jberet.spi.JobExecutor;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.UnboundedQueueThreadPoolAdd;
import org.jboss.as.threads.UnboundedQueueThreadPoolMetricsHandler;
import org.jboss.as.threads.UnboundedQueueThreadPoolRemove;
import org.jboss.as.threads.UnboundedQueueThreadPoolWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet.BatchSubsystemExtension;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.thread.pool.JobExecutorService;

public class BatchThreadPoolResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "thread-pool";
    static final PathElement PATH = PathElement.pathElement((String)"thread-pool");
    private final boolean registerRuntimeOnly;

    public BatchThreadPoolResourceDefinition(boolean registerRuntimeOnly) {
        super(new SimpleResourceDefinition.Parameters(PATH, (ResourceDescriptionResolver)BatchThreadPoolDescriptionResolver.INSTANCE).setAddHandler((OperationStepHandler)BatchThreadPoolAdd.INSTANCE).setRemoveHandler((OperationStepHandler)BatchThreadPoolRemove.INSTANCE).addCapabilities(new RuntimeCapability[]{Capabilities.THREAD_POOL_CAPABILITY}));
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PoolAttributeDefinitions.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        new UnboundedQueueThreadPoolWriteAttributeHandler(BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME).registerAttributes(resourceRegistration);
        if (this.registerRuntimeOnly) {
            new UnboundedQueueThreadPoolMetricsHandler(BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME).registerAttributes(resourceRegistration);
        }
    }

    private static class BatchThreadPoolDescriptionResolver
    extends StandardResourceDescriptionResolver {
        static final BatchThreadPoolDescriptionResolver INSTANCE = new BatchThreadPoolDescriptionResolver();
        private static final Set<String> COMMON_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("active-count", "completed-task-count", "current-thread-count", "keepalive-time", "largest-thread-count", "max-threads", "name", "queue-size", "task-count", "thread-factory"));
        private static final String COMMON_PREFIX = "threadpool.common";

        private BatchThreadPoolDescriptionResolver() {
            super("batch.jberet.thread-pool", BatchResourceDescriptionResolver.RESOURCE_NAME, BatchSubsystemExtension.class.getClassLoader(), true, false);
        }

        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
            if (COMMON_ATTRIBUTE_NAMES.contains(attributeName)) {
                return bundle.getString(this.getKey(attributeName));
            }
            return super.getResourceAttributeDescription(attributeName, locale, bundle);
        }

        public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.contains(attributeName)) {
                return bundle.getString(BatchThreadPoolDescriptionResolver.getVariableBundleKey((String)COMMON_PREFIX, (String[])new String[]{attributeName}, (String[])suffixes));
            }
            return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
        }

        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
            if ("add".equals(operationName) && COMMON_ATTRIBUTE_NAMES.contains(paramName)) {
                return bundle.getString(this.getKey(paramName));
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
        }

        public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
            if ("add".equals(operationName) && COMMON_ATTRIBUTE_NAMES.contains(paramName)) {
                return bundle.getString(BatchThreadPoolDescriptionResolver.getVariableBundleKey((String)COMMON_PREFIX, (String[])new String[]{paramName}, (String[])suffixes));
            }
            return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
        }

        private String getKey(String ... args) {
            return BatchThreadPoolDescriptionResolver.getVariableBundleKey((String)COMMON_PREFIX, (String[])args, (String[])new String[0]);
        }
    }

    static class BatchThreadPoolAdd
    extends UnboundedQueueThreadPoolAdd {
        static final BatchThreadPoolAdd INSTANCE = new BatchThreadPoolAdd((ThreadFactoryResolver)BatchThreadFactoryResolver.INSTANCE, BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME);
        private final ServiceName serviceNameBase;

        public BatchThreadPoolAdd(ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase) {
            super(threadFactoryResolver, serviceNameBase);
            this.serviceNameBase = serviceNameBase;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String name = context.getCurrentAddressValue();
            ServiceTarget target = context.getServiceTarget();
            ServiceName serviceName = context.getCapabilityServiceName(Capabilities.THREAD_POOL_CAPABILITY.getName(), name, JobExecutor.class);
            ServiceBuilder serviceBuilder = target.addService(serviceName);
            Consumer jobExecutorConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
            Supplier threadPoolSupplier = serviceBuilder.requires(this.serviceNameBase.append(new String[]{name}));
            JobExecutorService service = new JobExecutorService(jobExecutorConsumer, threadPoolSupplier);
            serviceBuilder.setInstance((Service)service);
            serviceBuilder.install();
        }
    }

    static class BatchThreadPoolRemove
    extends UnboundedQueueThreadPoolRemove {
        static final BatchThreadPoolRemove INSTANCE = new BatchThreadPoolRemove();

        public BatchThreadPoolRemove() {
            super((UnboundedQueueThreadPoolAdd)BatchThreadPoolAdd.INSTANCE);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            context.removeService(context.getCapabilityServiceName(Capabilities.THREAD_POOL_CAPABILITY.getName(), context.getCurrentAddressValue(), null));
            super.performRuntime(context, operation, model);
        }
    }

    private static class BatchThreadFactoryResolver
    extends ThreadFactoryResolver.SimpleResolver {
        static final BatchThreadFactoryResolver INSTANCE = new BatchThreadFactoryResolver();

        private BatchThreadFactoryResolver() {
            super(ThreadsServices.FACTORY);
        }

        protected String getThreadGroupName(String threadPoolName) {
            return "Batch Thread";
        }
    }
}

