/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.appclient.component.ApplicationClientComponentDescription;
import org.jboss.as.appclient.deployment.AppClientAttachments;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.service.ApplicationClientStartService;
import org.jboss.as.appclient.subsystem.AppClientSubsystemResourceDefinition;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.appclient.spec.ApplicationClientMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;

public class ApplicationClientStartProcessor
implements DeploymentUnitProcessor {
    private final String[] parameters;

    public ApplicationClientStartProcessor(String[] parameters) {
        this.parameters = parameters;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ClassReflectionIndex index;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        ApplicationClientMetaData appClientData = (ApplicationClientMetaData)deploymentUnit.getAttachment(AppClientAttachments.APPLICATION_CLIENT_META_DATA);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        Boolean activate = (Boolean)deploymentUnit.getAttachment(AppClientAttachments.START_APP_CLIENT);
        if (activate == null || !activate.booleanValue()) {
            return;
        }
        Class mainClass = (Class)deploymentUnit.getAttachment(AppClientAttachments.MAIN_CLASS);
        if (mainClass == null) {
            throw AppClientLogger.ROOT_LOGGER.cannotStartAppClient(deploymentUnit.getName());
        }
        ApplicationClientComponentDescription component = (ApplicationClientComponentDescription)((Object)deploymentUnit.getAttachment(AppClientAttachments.APPLICATION_CLIENT_COMPONENT));
        Method mainMethod = null;
        for (Class klass = mainClass; klass != Object.class && (mainMethod = (index = deploymentReflectionIndex.getClassIndex(klass)).getMethod(Void.TYPE, "main", new Class[]{String[].class})) == null; klass = klass.getSuperclass()) {
        }
        if (mainMethod == null) {
            throw AppClientLogger.ROOT_LOGGER.cannotStartAppClient(deploymentUnit.getName(), mainClass);
        }
        List setupActions = deploymentUnit.getAttachmentList(Attachments.OTHER_EE_SETUP_ACTIONS);
        ServiceBuilder builder = phaseContext.getServiceTarget().addService(deploymentUnit.getServiceName().append(ApplicationClientStartService.SERVICE_NAME));
        Supplier acdsSupplier = builder.requires(AppClientSubsystemResourceDefinition.APPCLIENT_CAPABILITY.getCapabilityServiceName());
        Supplier componentSupplier = builder.requires(component.getCreateServiceName());
        ApplicationClientStartService startService = new ApplicationClientStartService(mainMethod, this.parameters, moduleDescription.getNamespaceContextSelector(), (ClassLoader)module.getClassLoader(), setupActions, acdsSupplier, componentSupplier);
        builder.setInstance((Service)startService).install();
    }
}

