/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.batch.jberet;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SimpleItemWriter
extends AbstractItemWriter
implements ItemWriter {
    private static final Logger LOGGER = Logger.getLogger(SimpleItemWriter.class.getName());
    private final AtomicInteger counter = new AtomicInteger();
    @BatchProperty(name="writer.sleep")
    @Inject
    private String sleepTime;
    @BatchProperty(name="writer.failAt")
    @Inject
    private long failAt;
    @Inject
    private StepContext stepContext;
    private volatile long sleepMillis = -1L;

    public void open(Serializable checkpoint) throws Exception {
        if (this.sleepTime != null) {
            this.sleepMillis = Long.parseLong(this.sleepTime);
        }
        if (this.failAt == 0L) {
            this.failAt = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeItems(List<Object> items) throws Exception {
        try {
            for (Object item : items) {
                LOGGER.info("Item: " + item);
                if ((long)this.counter.incrementAndGet() != this.failAt) continue;
                throw new IllegalStateException("Failed at " + this.failAt + " per request");
            }
        }
        finally {
            long sleepMillis = this.sleepMillis;
            if (sleepMillis > 0L) {
                TimeUnit.MILLISECONDS.sleep(sleepMillis);
            }
        }
    }
}

