/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.batch.jberet;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class CountingItemReader
implements ItemReader {
    private final AtomicInteger counter = new AtomicInteger();
    @BatchProperty(name="chunk.start")
    @Inject
    private String start;
    @BatchProperty(name="chunk.end")
    @Inject
    private String end;
    private volatile int endCount;

    public void open(Serializable checkpoint) throws Exception {
        if (checkpoint != null) {
            this.counter.set((Integer)checkpoint);
        } else if (this.start != null) {
            this.counter.set(Integer.parseInt(this.start));
        }
        this.endCount = this.end == null ? 10 : Integer.parseInt(this.end);
    }

    public void close() throws Exception {
        this.counter.set(0);
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.counter.get());
    }

    public Object readItem() throws Exception {
        int current = this.counter.getAndIncrement();
        if (current < this.endCount) {
            return current;
        }
        return null;
    }
}

