/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.keycloak.runtime;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import javax.servlet.ServletContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.undertow.OIDCUndertowHttpFacade;
import org.wildfly.swarm.keycloak.runtime.KeycloakSecurityContextAssociation;

public class SecurityContextServletExtension
implements ServletExtension {
    public void handleDeployment(DeploymentInfo info, ServletContext context) {
        System.err.println("HANDLE DEPLOYMENT FOR SECURITY CONTEXT");
        info.addThreadSetupAction(new ThreadSetupAction(){

            public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
                if (exchange == null) {
                    return null;
                }
                KeycloakSecurityContext c = (KeycloakSecurityContext)exchange.getAttachment(OIDCUndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY);
                KeycloakSecurityContextAssociation.associate(c);
                return new ThreadSetupAction.Handle(){

                    public void tearDown() {
                        KeycloakSecurityContextAssociation.disassociate();
                    }
                };
            }
        });
        info.addInnerHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(final HttpHandler next) {
                return new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        KeycloakSecurityContext c = (KeycloakSecurityContext)exchange.getAttachment(OIDCUndertowHttpFacade.KEYCLOAK_SECURITY_CONTEXT_KEY);
                        if (c != null) {
                            KeycloakSecurityContextAssociation.associate(c);
                        }
                        try {
                            next.handleRequest(exchange);
                        }
                        finally {
                            KeycloakSecurityContextAssociation.disassociate();
                        }
                    }
                };
            }
        });
    }
}

