/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.flyway.runtime;

import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.config.datasources.DataSource;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.flyway.FlywayFraction;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;
import org.wildfly.swarm.undertow.descriptors.WebXmlContainer;

public class FlywayMigrationArchivePreparer
implements ArchivePreparer {
    @Inject
    private Instance<DatasourcesFraction> dsFractionInstance;
    @Inject
    private Instance<FlywayFraction> flywayFractionInstance;

    public void prepareArchive(Archive<?> archive) {
        if (archive instanceof WebXmlContainer) {
            WebXmlContainer webArchive = (WebXmlContainer)archive;
            WebXmlAsset webXml = webArchive.findWebXmlAsset();
            webXml.addListener("org.wildfly.swarm.flyway.deployment.FlywayMigrationServletContextListener");
            FlywayFraction flywayFraction = (FlywayFraction)this.flywayFractionInstance.get();
            if (flywayFraction.usePrimaryDataSource()) {
                String dataSourceJndi = this.getDatasourceNameJndi();
                webXml.setContextParam("flyway.jndi.datasource", new String[]{dataSourceJndi});
            } else {
                webXml.setContextParam("flyway.jdbc.url", new String[]{flywayFraction.jdbcUrl()});
                webXml.setContextParam("flyway.jdbc.user", new String[]{flywayFraction.jdbcUser()});
                webXml.setContextParam("flyway.jdbc.password", new String[]{flywayFraction.jdbcPassword()});
            }
        }
    }

    private String getDatasourceNameJndi() {
        List dataSources;
        String jndiName = "java:jboss/datasources/ExampleDS";
        if (!this.dsFractionInstance.isUnsatisfied() && (dataSources = ((DatasourcesFraction)this.dsFractionInstance.get()).subresources().dataSources()).size() > 0) {
            jndiName = ((DataSource)dataSources.get(0)).jndiName();
        }
        return jndiName;
    }
}

