/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.marshal;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.spi.runtime.ConfigurationMarshaller;

@ApplicationScoped
public class InterfaceMarshaller
implements ConfigurationMarshaller {
    private static final String INTERFACE_NAME = "interface";
    @Inject
    @Any
    private Instance<Interface> interfaces;

    public void marshal(List<ModelNode> list) {
        for (Interface iface : this.interfaces) {
            this.configureInterface(iface, list);
        }
    }

    private void configureInterface(Interface iface, List<ModelNode> list) {
        if (this.hasInterface(iface, list)) {
            return;
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(INTERFACE_NAME, iface.getName());
        node.get("inet-address").set(new ValueExpression(iface.getExpression()));
        list.add(node);
    }

    private boolean hasInterface(Interface iface, List<ModelNode> list) {
        return list.stream().anyMatch(e -> {
            if (!e.get("operation").asString().equals("add")) {
                return false;
            }
            ModelNode addr = e.get("address");
            if (addr.getType() != ModelType.LIST) {
                return false;
            }
            List addrList = addr.asList();
            if (addrList.size() != 1) {
                return false;
            }
            Property addrProp = ((ModelNode)addrList.get(0)).asProperty();
            String propName = addrProp.getName();
            String propValue = addrProp.getValue().asString();
            return propName.equals(INTERFACE_NAME) && propValue.equals(iface.getName());
        });
    }
}

