/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=undertow/configuration=handler/file=*")
@ResourceType(value="file")
public class File<T extends File<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Size of the buffers, in bytes.")
    private Long cacheBufferSize;
    @AttributeDocumentation(value="Number of buffers")
    private Long cacheBuffers;
    @AttributeDocumentation(value="Use case sensitive file handling")
    private Boolean caseSensitive;
    @AttributeDocumentation(value="Enable directory listing?")
    private Boolean directoryListing;
    @AttributeDocumentation(value="Enable following symbolic links")
    private Boolean followSymlink;
    @AttributeDocumentation(value="Path on filesystem from where file handler will serve resources")
    private String path;
    @AttributeDocumentation(value="Paths that are safe to be targets of symbolic links")
    private List<String> safeSymlinkPaths;

    public File(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="cache-buffer-size")
    public Long cacheBufferSize() {
        return this.cacheBufferSize;
    }

    public T cacheBufferSize(Long value) {
        Long oldValue = this.cacheBufferSize;
        this.cacheBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache-buffers")
    public Long cacheBuffers() {
        return this.cacheBuffers;
    }

    public T cacheBuffers(Long value) {
        Long oldValue = this.cacheBuffers;
        this.cacheBuffers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheBuffers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="case-sensitive")
    public Boolean caseSensitive() {
        return this.caseSensitive;
    }

    public T caseSensitive(Boolean value) {
        Boolean oldValue = this.caseSensitive;
        this.caseSensitive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("caseSensitive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="directory-listing")
    public Boolean directoryListing() {
        return this.directoryListing;
    }

    public T directoryListing(Boolean value) {
        Boolean oldValue = this.directoryListing;
        this.directoryListing = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("directoryListing", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="follow-symlink")
    public Boolean followSymlink() {
        return this.followSymlink;
    }

    public T followSymlink(Boolean value) {
        Boolean oldValue = this.followSymlink;
        this.followSymlink = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("followSymlink", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="safe-symlink-paths")
    public List<String> safeSymlinkPaths() {
        return this.safeSymlinkPaths;
    }

    public T safeSymlinkPaths(List<String> value) {
        List<String> oldValue = this.safeSymlinkPaths;
        this.safeSymlinkPaths = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("safeSymlinkPaths", oldValue, value);
        }
        return (T)this;
    }

    public T safeSymlinkPath(String value) {
        if (this.safeSymlinkPaths == null) {
            this.safeSymlinkPaths = new ArrayList<String>();
        }
        this.safeSymlinkPaths.add(value);
        return (T)this;
    }

    public T safeSymlinkPaths(String ... args) {
        this.safeSymlinkPaths(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

