/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.elytron.Format;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/syslog-audit-log=*")
@ResourceType(value="syslog-audit-log")
public class SyslogAuditLog<T extends SyslogAuditLog<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The format to use to record the audit event.")
    private Format format;
    @AttributeDocumentation(value="The host name to embed withing all events sent to the remote syslog server.")
    private String hostName;
    @AttributeDocumentation(value="The listening port on the syslog server.")
    private Integer port;
    @AttributeDocumentation(value="The server address of the syslog server the events should be sent to.")
    private String serverAddress;
    @AttributeDocumentation(value="The SSLContext to use to connect to the syslog server when SSL_TCP transport is used.")
    private String sslContext;
    @AttributeDocumentation(value="The transport to use to connect to the syslog server.")
    private Transport transport;

    public SyslogAuditLog(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="format")
    public Format format() {
        return this.format;
    }

    public T format(Format value) {
        Format oldValue = this.format;
        this.format = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("format", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="host-name")
    public String hostName() {
        return this.hostName;
    }

    public T hostName(String value) {
        String oldValue = this.hostName;
        this.hostName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hostName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="port")
    public Integer port() {
        return this.port;
    }

    public T port(Integer value) {
        Integer oldValue = this.port;
        this.port = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("port", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-address")
    public String serverAddress() {
        return this.serverAddress;
    }

    public T serverAddress(String value) {
        String oldValue = this.serverAddress;
        this.serverAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-context")
    public String sslContext() {
        return this.sslContext;
    }

    public T sslContext(String value) {
        String oldValue = this.sslContext;
        this.sslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transport")
    public Transport transport() {
        return this.transport;
    }

    public T transport(Transport value) {
        Transport oldValue = this.transport;
        this.transport = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transport", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum Transport {
        TCP("TCP"),
        UDP("UDP"),
        SSL_TCP("SSL_TCP");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Transport(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

