/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/simple-permission-mapper=*")
@ResourceType(value="simple-permission-mapper")
public class SimplePermissionMapper<T extends SimplePermissionMapper<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The mapping mode that should be used in the event of multiple matches.")
    private MappingMode mappingMode;
    @AttributeDocumentation(value="The defined permission mappings.")
    private List<Map> permissionMappings;

    public SimplePermissionMapper(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="mapping-mode")
    public MappingMode mappingMode() {
        return this.mappingMode;
    }

    public T mappingMode(MappingMode value) {
        MappingMode oldValue = this.mappingMode;
        this.mappingMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mappingMode", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="permission-mappings")
    public List<Map> permissionMappings() {
        return this.permissionMappings;
    }

    public T permissionMappings(List<Map> value) {
        List<Map> oldValue = this.permissionMappings;
        this.permissionMappings = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("permissionMappings", oldValue, value);
        }
        return (T)this;
    }

    public T permissionMapping(Map value) {
        if (this.permissionMappings == null) {
            this.permissionMappings = new ArrayList<Map>();
        }
        this.permissionMappings.add(value);
        return (T)this;
    }

    public T permissionMappings(Map ... args) {
        this.permissionMappings(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    public static enum MappingMode {
        AND("and"),
        OR("or"),
        XOR("xor"),
        UNLESS("unless"),
        FIRST("first");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private MappingMode(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

