/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/provider-loader=*")
@ResourceType(value="provider-loader")
public class ProviderLoader<T extends ProviderLoader<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The list of providers loaded by this provider loader.")
    private List<Map> loadedProviders;
    @AttributeDocumentation(value="The fully qualified class names of the providers to load, these are loaded after the service-loader discovered providers and duplicates will be skipped.")
    private List<String> classNames;
    @AttributeDocumentation(value="The name of the module to load the provider from.")
    private String module;
    @AttributeDocumentation(value="An argument to be passed into the constructor as the Provider is instantiated.")
    private String argument;
    @AttributeDocumentation(value="The key/value configuration to be passed to the Provider to initialise it.")
    private Map configuration;
    @AttributeDocumentation(value="The path of the file to use to initialise the providers.")
    private String path;
    @AttributeDocumentation(value="The base path of the configuration file.")
    private String relativeTo;

    public ProviderLoader(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="loaded-providers")
    public List<Map> loadedProviders() {
        return this.loadedProviders;
    }

    public T loadedProviders(List<Map> value) {
        List<Map> oldValue = this.loadedProviders;
        this.loadedProviders = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("loadedProviders", oldValue, value);
        }
        return (T)this;
    }

    public T loadedProvider(Map value) {
        if (this.loadedProviders == null) {
            this.loadedProviders = new ArrayList<Map>();
        }
        this.loadedProviders.add(value);
        return (T)this;
    }

    public T loadedProviders(Map ... args) {
        this.loadedProviders(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="class-names")
    public List<String> classNames() {
        return this.classNames;
    }

    public T classNames(List<String> value) {
        List<String> oldValue = this.classNames;
        this.classNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("classNames", oldValue, value);
        }
        return (T)this;
    }

    public T className(String value) {
        if (this.classNames == null) {
            this.classNames = new ArrayList<String>();
        }
        this.classNames.add(value);
        return (T)this;
    }

    public T classNames(String ... args) {
        this.classNames(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="argument")
    public String argument() {
        return this.argument;
    }

    public T argument(String value) {
        String oldValue = this.argument;
        this.argument = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("argument", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="configuration")
    public Map configuration() {
        return this.configuration;
    }

    public T configuration(Map value) {
        Map oldValue = this.configuration;
        this.configuration = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("configuration", oldValue, value);
        }
        return (T)this;
    }

    public T configuration(String key, Object value) {
        if (this.configuration == null) {
            this.configuration = new HashMap();
        }
        this.configuration.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }
}

