/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/dir-context=*")
@ResourceType(value="dir-context")
public class DirContext<T extends DirContext<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The authentication context to obtain login credentials to connect to the LDAP server. Can be omitted if authentication-level is \"none\" (anonymous).")
    private String authenticationContext;
    @AttributeDocumentation(value="The authentication level (security level/authentication mechanism) to use. Corresponds to SECURITY_AUTHENTICATION (\"java.naming.security.authentication\") environment property. Allowed values: \"none\", \"simple\", sasl_mech, where sasl_mech is a space-separated list of SASL mechanism names.")
    private String authenticationLevel;
    @AttributeDocumentation(value="The timeout for connecting to the LDAP server in milliseconds.")
    private Integer connectionTimeout;
    @AttributeDocumentation(value="The credential reference to authenticate and connect to the LDAP server. Can be omitted if authentication-level is \"none\" (anonymous).")
    private Map credentialReference;
    @AttributeDocumentation(value="Indicates if connection pooling is enabled.")
    private Boolean enableConnectionPooling;
    @AttributeDocumentation(value="Name of module that will be used as class loading base.")
    private String module;
    @AttributeDocumentation(value="The principal to authenticate and connect to the LDAP server. Can be omitted if authentication-level is \"none\" (anonymous).")
    private String principal;
    @AttributeDocumentation(value="The additional connection properties for the DirContext.")
    private Map properties;
    @AttributeDocumentation(value="The read timeout for an LDAP operation in milliseconds.")
    private Integer readTimeout;
    @AttributeDocumentation(value="If referrals should be followed.")
    private ReferralMode referralMode;
    @AttributeDocumentation(value="The name of ssl-context used to secure connection to the LDAP server.")
    private String sslContext;
    @AttributeDocumentation(value="The connection url.")
    private String url;

    public DirContext(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="authentication-context")
    public String authenticationContext() {
        return this.authenticationContext;
    }

    public T authenticationContext(String value) {
        String oldValue = this.authenticationContext;
        this.authenticationContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-level")
    public String authenticationLevel() {
        return this.authenticationLevel;
    }

    public T authenticationLevel(String value) {
        String oldValue = this.authenticationLevel;
        this.authenticationLevel = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationLevel", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-timeout")
    public Integer connectionTimeout() {
        return this.connectionTimeout;
    }

    public T connectionTimeout(Integer value) {
        Integer oldValue = this.connectionTimeout;
        this.connectionTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="credential-reference")
    public Map credentialReference() {
        return this.credentialReference;
    }

    public T credentialReference(Map value) {
        Map oldValue = this.credentialReference;
        this.credentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("credentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T credentialReference(String key, Object value) {
        if (this.credentialReference == null) {
            this.credentialReference = new HashMap();
        }
        this.credentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-connection-pooling")
    public Boolean enableConnectionPooling() {
        return this.enableConnectionPooling;
    }

    public T enableConnectionPooling(Boolean value) {
        Boolean oldValue = this.enableConnectionPooling;
        this.enableConnectionPooling = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableConnectionPooling", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="principal")
    public String principal() {
        return this.principal;
    }

    public T principal(String value) {
        String oldValue = this.principal;
        this.principal = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principal", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="read-timeout")
    public Integer readTimeout() {
        return this.readTimeout;
    }

    public T readTimeout(Integer value) {
        Integer oldValue = this.readTimeout;
        this.readTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("readTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="referral-mode")
    public ReferralMode referralMode() {
        return this.referralMode;
    }

    public T referralMode(ReferralMode value) {
        ReferralMode oldValue = this.referralMode;
        this.referralMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("referralMode", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-context")
    public String sslContext() {
        return this.sslContext;
    }

    public T sslContext(String value) {
        String oldValue = this.sslContext;
        this.sslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url")
    public String url() {
        return this.url;
    }

    public T url(String value) {
        String oldValue = this.url;
        this.url = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("url", oldValue, value);
        }
        return (T)this;
    }

    public static enum ReferralMode {
        FOLLOW("FOLLOW"),
        IGNORE("IGNORE"),
        THROW("THROW");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ReferralMode(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

